﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>

#include <glv_ScissorBoxView.h>
#include <nn/nn_Common.h>

#include "DevMenu_AccountsConfig.h"
#include "DevMenu_AccountsUiComponents.h"
#include "../Common/DevMenu_CommonScene.h"

namespace devmenu { namespace accounts {

class AsyncTaskScene
    : public Scene
{
private:
    class Canceller
        : public Button
    {
    private:
        AsyncTaskScene& m_Parent;

        void CancelEventCallback() NN_NOEXCEPT;

    public:
        Canceller(const AbstractOperators& op, AsyncTaskScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
    };

    class Closer
        : public Button
    {
    private:
        const AbstractOperators& m_Op;
        AsyncTaskScene& m_Parent;

        void CloseEventCallback() NN_NOEXCEPT;

    public:
        Closer(const AbstractOperators& op, AsyncTaskScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
    };

    class Label
        : public glv::View
    {
    private:
        glv::Placer m_Placer;
        glv::Label* m_pTitle;
        glv::Label* m_pDescription;

        enum Mode
        {
            Mode_Progress,
            Mode_Result,
        } m_Mode;
        nn::Result m_Result;

    public:
        Label(AsyncTaskScene& parent, const glv::Rect& result) NN_NOEXCEPT;

        void SetProgress() NN_NOEXCEPT;
        void SetResult(nn::Result r) NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;
    };

    glv::ScissorBoxView m_Base;
    glv::Placer m_Placer;
    Canceller m_Canceller;
    Closer m_Closer;
    Label m_Label;

    // 非同期処理
    nn::account::AsyncContext* m_pContext;
    nn::os::SystemEvent* m_pWaiter;
    Scene* m_pPreviousScene;

public:
    AsyncTaskScene(const AbstractOperators& op, glv::Rect rect) NN_NOEXCEPT;
    ~AsyncTaskScene() NN_NOEXCEPT;

    glv::View* GetPrimaryView() NN_NOEXCEPT;

    void SetContext(nn::account::AsyncContext&& context, Scene* pPrev) NN_NOEXCEPT;
    void Cancel() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
    void Refresh() NN_NOEXCEPT;
};

}} // ~namespace devmenu::accounts, ~namespace devmenu

