﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <glv.h>

#include "Base/BcatTestApp_Sequence.h"
#include "Base/BcatTestApp_ConsoleCore.h"
#include "Base/BcatTestApp_Utility.h"
#include "Common/BcatTestApp_Dialog.h"
#include "Common/BcatTestApp_BaseDisplay.h"

namespace app
{

namespace {
//----------------------------------------------------------------
// ダイアログからの戻り
void AfterDialog( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    app::sequence::Return();
}
}

//----------------------------------------------------------------
// ユーザが選択されなかった場合のダイアログ
//
void SetInvalidUserDialog( bool isReturnAfterDialog ) NN_NOEXCEPT
{
    app::DialogParam* p = app::AllocDialogParam( DialogParam::InfoType_Caution );
    p->GetConsole()->PrintfEx( 0, 0,
                               IsEnglish() ?
                               u"An appropriate user is not selected." :
                               u"ユーザが正しく選択されていません。" );
    app::sequence::Call( app::ExecDialogGroup, p );
    if ( isReturnAfterDialog )
    {
        app::sequence::SetFromCall( AfterDialog, nullptr );
    }
}

//----------------------------------------------------------------
// エラーダイアログ
//
void SetErrorDialog( const char16_t* message, nn::Result result ) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL( message );

    app::DialogParam* p = app::AllocDialogParam( DialogParam::InfoType_Caution );
    p->SetMessage16( message );
    if ( result.IsFailure() )
    {
        p->SetResult( result );
    }
    app::sequence::Call( app::ExecDialogGroup, p );
}

//----------------------------------------------------------------
// 通知ダイアログ
//
void SetNoticeDialog( const char16_t* pMessage[], int lines ) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL( pMessage );

    app::DialogParam* p = app::AllocDialogParam( DialogParam::InfoType_Notice );

    for( int i=0; i<lines; i++ )
    {
        p->GetConsole()->PrintfEx( 0, i, pMessage[i] );
    }
    app::sequence::Call( app::ExecDialogGroup, p );
}

} //namespace app
