﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "BcatTestApp_Common.h"
#include "BcatTestApp_TopMenu.h"
#include "BcatTestApp_DirectoryMenu.h"
#include "BcatTestApp_SaveAllFile.h"

namespace app
{
void ExecStorageMenu_Initialize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void ExecStorageMenu           ( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void ExecStorageMenu_Finalize  ( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void DrawStorageMenu( void* arg ) NN_NOEXCEPT;

void ExecStorageMenu_DetermineDirectoryName( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;

ExecCallbackGroup ExecStorageMenuGroup = {
    ExecStorageMenu_Initialize,
    ExecStorageMenu,
    ExecStorageMenu_Finalize,
    nullptr,

    DrawStorageMenu,
    nullptr,
    DrawPriority_StorageMenu,
    0
};

namespace
{
    app::Menu g_Menu;
    enum
    {
        MenuIndex_EnumerateDirectoris = 0,
        MenuIndex_SaveDifference,
        MenuIndex_SaveAllForcibly,
        MenuIndex_SaveToSdCard,
    };
    int g_InitialMenuIndex = MenuIndex_EnumerateDirectoris;
    const int MenuMax = MenuIndex_SaveToSdCard + 1;

    // 処理経過コンソール
    const int InputStrConsoleWidth = 80;
    const int InputStrConsoleHeight = 10;
    const int InputStrConsoleBufferSize = APP_CONSOLE_BUFFER_SIZE_CHAR16( InputStrConsoleWidth, InputStrConsoleHeight );
    char* g_pInputStrConsoleBuffer;
    app::FixedConsole<char16_t> g_InputStrConsole;

    char g_DirectoryName[ 32 ];

//----------------------------------------------------------------
// 固定フォントのコンソールプリンタ
//
void DrawFixedConsoleString( int x, int y, char16_t* string, char* attr, int stringLen, void* arg ) NN_NOEXCEPT
{
    const float FontSize = 24.0F;
    const float GridSizeX = 16.0F;
    const float GridSizeY = 28.0F;
    DrawFixedConsoleGeneric16( Position_SaveAllFile.l,
                             Position_SaveAllFile.t,
                             FontSize, GridSizeX, GridSizeY,
                             x, y, string, attr, stringLen, arg );
}
} // namespace

//----------------------------------------------------------------
// ストレージメニュー用描画コールバック
//
void DrawStorageMenu( void* arg ) NN_NOEXCEPT
{
}

//----------------------------------------------------------------
// ストレージメニューのメニュー文字列描画
//
void DrawStorageMenuItems() NN_NOEXCEPT
{
    app::FixedProportionalConsole<char16_t>* p = g_Menu.GetConsole16();
    if ( p )
    {
        app::SetGlvColor( app::ColorSet_White );
        p->PrintfEx( 1, 0,
                     u"-- ストレージメニュー --" );
        p->PrintfEx( 2, 2,
                     app::ConsoleColor_White,
                     u"ディレクトリの列挙 : nn::bcat::EnumerateDeliveryCacheDirectory()" );
        p->PrintfEx( 2, 3,
                     app::ConsoleColor_White,
                     u"セーブデータへ全体セーブ(差分ファイルのみ)..." );
        p->PrintfEx( 2, 4,
                     app::ConsoleColor_White,
                     u"セーブデータへ全体セーブ(すべて上書き)..." );
        p->PrintfEx( 2, 5,
                     app::ConsoleColor_White,
                     u"SDカードへ保存..." );
    }
}

namespace
{
//----------------------------------------------------------------
// 文字列入力のキー説明
void PrintInputStrHelp() NN_NOEXCEPT
{
    app::GetHelpConsole().Clear();
    app::GetHelpConsole().PrintfEx( 2, 0,
                                    u"@1操作説明:@7 @6[上][下][左][右]@7...カーソル  @4[A]@7...入力  @3[Y]@7...削除  @5[X]@7...決定  @2[B]@7...戻る" );
}


app::SaveAllFileParam g_SaveAllFileParam;

void FromDialog_SaveDifference( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    app::DialogReturnParam* p = reinterpret_cast<app::DialogReturnParam*>( app::sequence::GetReturnArg() );
    if ( p->IsSelectedYes() )
    {
        g_SaveAllFileParam.saveTarget = app::SaveAllFileTarget_SaveData;
        g_SaveAllFileParam.saveType = app::SaveAllFileType_Difference;
        app::sequence::Call( app::ExecSaveAllFileGroup, &g_SaveAllFileParam );
    }
}
void FromDialog_SaveAllForcigly( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    app::DialogReturnParam* p = reinterpret_cast<app::DialogReturnParam*>( app::sequence::GetReturnArg() );
    if ( p->IsSelectedYes() )
    {
        g_SaveAllFileParam.saveTarget = app::SaveAllFileTarget_SaveData;
        g_SaveAllFileParam.saveType = app::SaveAllFileType_AllForciby;
        app::sequence::Call( app::ExecSaveAllFileGroup, &g_SaveAllFileParam );
    }
}
void FromDialog_SaveToSdCard( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    app::DialogReturnParam* p = reinterpret_cast<app::DialogReturnParam*>( app::sequence::GetReturnArg() );
    if ( p->IsSelectedYes() )
    {
        PrintInputStrHelp();

        // 保存先のディレクトリ名入力へ
        app::sequence::SlideTo( ExecStorageMenu_DetermineDirectoryName );
    }
}

}

//----------------------------------------------------------------
// 「差分セーブ」項目の処理
void StorageMenu_SaveDifference() NN_NOEXCEPT
{
    app::DialogParam* p = app::AllocDialogParam( app::DialogParam::InfoType_YesNo );
    p->GetConsole()->PrintfEx( 0, 0, u"セーブデータを差分更新してよろしいですか？" );
    p->SetReturnDelay( 5 );
    app::sequence::Call( app::ExecDialogGroup, p );
    app::sequence::SetFromCall( FromDialog_SaveDifference, nullptr );
}
//----------------------------------------------------------------
// 「強制的に全部セーブ」項目の処理
void StorageMenu_SaveAllForcibly() NN_NOEXCEPT
{
    app::DialogParam* p = app::AllocDialogParam( app::DialogParam::InfoType_YesNo );
    p->GetConsole()->PrintfEx( 0, 0, u"セーブデータを全部上書きしてよろしいですか？" );
    p->SetReturnDelay( 5 );
    app::sequence::Call( app::ExecDialogGroup, p );
    app::sequence::SetFromCall( FromDialog_SaveAllForcigly, nullptr );
}
//----------------------------------------------------------------
void StorageMenu_SaveToSdCard() NN_NOEXCEPT
{
    app::DialogParam* p = app::AllocDialogParam( app::DialogParam::InfoType_YesNo );
    p->GetConsole()->PrintfEx( 0, 0, u"配信データ全体を SD カードへ保存しますか？" );
    p->SetReturnDelay( 5 );
    app::sequence::Call( app::ExecDialogGroup, p );
    app::sequence::SetFromCall( FromDialog_SaveToSdCard, nullptr );
}

//----------------------------------------------------------------
// ストレージメニューのキー説明
void PrintStorageMenuHelp() NN_NOEXCEPT
{
    app::GetHelpConsole().Clear();
    app::GetHelpConsole().PrintfEx( 2, 0,
                                    u"@1操作説明:@7 @6[上][下]@7...カーソル  @4[A]@7...決定  @2[B]@7...戻る" );
}

//----------------------------------------------------------------
// ストレージメニュー(開始処理)
//
void ExecStorageMenu_Initialize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    // メニュー作成
    g_Menu.CreateConsole( app::ConsoleSize_Char16_t, app::Position_StorageMenu, 100, 4, 1, 2, 24, 4, DrawPriority_StorageMenu + 1, 0x230 );
    g_Menu.SetBackColor( app::ColorSet_DarkGreen, app::ColorSet_Green, app::DrawFrameWidth );
    g_Menu.SetItemParameter( MenuMax, g_InitialMenuIndex );
    DrawStorageMenuItems();

    // コンソール作成
    g_pInputStrConsoleBuffer = new char[ InputStrConsoleBufferSize ];
    g_InputStrConsole.SetBuffer( g_pInputStrConsoleBuffer, InputStrConsoleBufferSize, InputStrConsoleWidth, InputStrConsoleHeight );
    g_InputStrConsole.SetPrinter( DrawFixedConsoleString );

    // キー説明
    PrintStorageMenuHelp();
}
//----------------------------------------------------------------
// ストレージメニュー(終了処理)
//
void ExecStorageMenu_Finalize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    g_Menu.DestroyConsole();
    delete[] g_pInputStrConsoleBuffer;
}
//----------------------------------------------------------------
// ストレージメニュー
//
void ExecStorageMenu( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    g_Menu.SetHidEvent( &events );
    g_Menu.Update();

    switch( g_Menu.CheckButtonOk() )
    {
        case MenuIndex_EnumerateDirectoris:
            {
                g_InitialMenuIndex = MenuIndex_EnumerateDirectoris;
                app::sequence::JumpTo( ExecDirectoryMenuGroup );
                return;
            }
            break;
        case MenuIndex_SaveDifference:
            {
                g_InitialMenuIndex = MenuIndex_EnumerateDirectoris;
                StorageMenu_SaveDifference();
                return;
            }
            break;
        case MenuIndex_SaveAllForcibly:
            {
                g_InitialMenuIndex = MenuIndex_EnumerateDirectoris;
                StorageMenu_SaveAllForcibly();
                return;
            }
            break;
        case MenuIndex_SaveToSdCard:
            {
                g_InitialMenuIndex = MenuIndex_EnumerateDirectoris;
                StorageMenu_SaveToSdCard();
            }
            break;
        default:
            break;
    }


    // B ボタンで戻る
    if ( g_Menu.CheckButtonCancel() )
    {
        app::sequence::JumpTo( ExecTopMenuGroup );
    }

    if ( g_Menu.IsUpdated() )
    {
        DrawStorageMenuItems();
        g_Menu.ClearUpdated();
    }
}

//----------------------------------------------------------------
// 文字列入力ダイアログからの戻り
//  (ストレージメニューに戻るか、SDカード保存を行うか)
//
void FromInputString( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    //app::DialogReturnParam* p = reinterpret_cast<app::DialogReturnParam*>( app::sequence::GetReturnArg() );
    app::InputStringReturnParam* p = reinterpret_cast<app::InputStringReturnParam*>( app::sequence::GetReturnArg() );

    // キャンセルだった
    //if ( ! p->isInputStrValid )
    if ( ! p->IsValid() )
    {
        PrintStorageMenuHelp();
        app::sequence::SlideTo( ExecStorageMenu );
        return;
    }

    // 文字列を入れていない(キャンセル扱い)
    //if ( strlen( p->GetInputString() ) == 0 )
    if ( strlen( p->GetString() ) == 0 )
    {
        app::DialogParam* dp = app::AllocDialogParam( app::DialogParam::InfoType_Caution );
        dp->SetMessage16( u"ディレクトリ名が不正です" );
        app::sequence::Call( app::ExecDialogGroup, dp );
        app::sequence::SlideTo( ExecStorageMenu );
        return;
    }
    //strncpy( g_DirectoryName, p->GetInputString(), 32 );
    strncpy( g_DirectoryName, p->GetString(), 32 );
    g_DirectoryName[31] = '\0';

    // SDカードへ保存
    g_SaveAllFileParam.saveTarget = app::SaveAllFileTarget_SdCard;
    g_SaveAllFileParam.pDirectoryName = g_DirectoryName;

    app::sequence::Call( app::ExecSaveAllFileGroup, &g_SaveAllFileParam );
    app::sequence::SlideTo( ExecStorageMenu );
}

//----------------------------------------------------------------
// SDカードのデフォルト保存フォルダ名を時刻から取得
//
void GetSdCardFolder( char* pName ) NN_NOEXCEPT
{
    int year, month, day, hour, minute, second;

    if ( ! GetCurrentTime( &year, &month, &day, &hour, &minute, &second ) )
    {
        strcpy( pName, "BTA_XXXX-XX-XX_XX-XX-XX" );
        return;
    }

    sprintf( pName, "BTA_%4d-%02d-%02d_%02d-%02d-%02d", year, month, day, hour, minute, second );
}


//----------------------------------------------------------------
// 文字列入力ダイアログを呼び出す実行コールバック
//
void ExecStorageMenu_DetermineDirectoryName( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    //app::DialogParam* p = app::AllocDialogParam( app::DialogParam::InfoType_InputStr );
    app::InputStringParam* p = app::AllocInputStringParam();

    p->GetConsole()->PrintfEx( 0, 0, u"保存するSDカード上のディレクトリ名を入力してください" );
    //p->SetInputStrLen( 31 );
    p->SetLength( 31 );
    p->SetReturnDelay( 5 );
    char s[32];
    GetSdCardFolder( s );
    //p->SetInitialInputStr( s );
    p->SetInitialString( s );

    //app::sequence::Call( app::ExecDialogGroup, p );
    app::sequence::Call( app::ExecInputStringGroup, p );
    app::sequence::SetFromCall( FromInputString, nullptr );
}



} // namespace app
