﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace app
{

int RotateWithinRange( int value, int incValue, int min, int max ) NN_NOEXCEPT;

void RotateWithinViewRange( int& position, int incValue, int& viewTop, int viewLen, int max ) NN_NOEXCEPT;

void MoveWithinFixViewRange( int& position, int incValue, int viewLen, int max ) NN_NOEXCEPT;

int GetRepeatCount( int count, int maxLen ) NN_NOEXCEPT;

void CalculateScrollBarPosition( int64_t wholeSize, int64_t displaySize, int64_t currentPosition,
                                 float posStart, float posEnd, float minWidth,
                                 float* pStart, float* pEnd ) NN_NOEXCEPT;

size_t StrLen16( const char16_t* s ) NN_NOEXCEPT;

char16_t* ConvertToChar16_t( const char* format, ... ) NN_NOEXCEPT;

}
