﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "BcatSystemDebugTool_Common.h"

#include "BcatSystemDebugTool_TopMenu.h"

namespace app
{
void ExecDataInitMenu_Initialize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void ExecDataInitMenu           ( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void ExecDataInitMenu_Finalize  ( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void DrawDataInitMenu( void* arg ) NN_NOEXCEPT;

ExecCallbackGroup ExecDataInitMenuGroup = {
    ExecDataInitMenu_Initialize,
    ExecDataInitMenu,
    ExecDataInitMenu_Finalize,
    nullptr,

    DrawDataInitMenu,
    nullptr,
    DrawPriority_SubMenu,
    0
};

namespace
{
    app::Menu g_Menu;

    enum
     {
         MenuIndex_InitData = 0,
         MenuIndex_Cancel,
     };
} //namespace

//----------------------------------------------------------------
void DrawDataInitMenu( void* arg ) NN_NOEXCEPT
{
    app::FixedProportionalConsole<char>& c = GetScreenConsole();
    uint64_t count = app::sequence::GetDrawFrameCount();

    c.PrintfEx( 2, 3,
                (count & 0x8)? app::ConsoleColor_Red: app::ConsoleColor_Yellow,
                "*** Initialize Save Data ? ***" );
}

//----------------------------------------------------------------
void ExecDataInitMenu_Initialize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    app::FixedProportionalConsole<char>& c = GetScreenConsole();
    c.SetAttribute( app::ConsoleColor_White );
    c.PrintfEx( 3, 5, "YES" );
    c.PrintfEx( 3, 6, "NO" );

    app::RectanglePosition position( 0,10,100,100 );
    g_Menu.CreateConsole( app::ConsoleSize_Char16_t, position, 10, 3, 3, 5, 24, 4, app::DrawPriority_SubMenu + 1, 100 );
    g_Menu.SetItemParameter( 2, 1 );
}
//----------------------------------------------------------------
void ExecDataInitMenu_Finalize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    g_Menu.DestroyConsole();
}
//----------------------------------------------------------------
void ExecDataInitMenu( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    app::FixedProportionalConsole<char>& c = GetScreenConsole();

    // キー確認
    g_Menu.SetHidEvent( &events );
    g_Menu.Update();
    int okIndex = g_Menu.CheckButtonOk();

    //---- 決定
    if ( okIndex == MenuIndex_InitData )
    {
        c.Printf("Initialize Save Data.");

        // TODO:
        // 処理はまだ
    }

    //---- キャンセル
    if ( okIndex == MenuIndex_Cancel || g_Menu.CheckButtonCancel() )
    {
        //c.ClearLine(3);
        app::sequence::JumpTo( ExecTopMenuGroup, nullptr );
    }
}

} // namespace app
