﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

uniform mat4 uUser;

in vec3 aVertex;
in vec4 aColor;
in vec3 aTexCoord0;

out vec4 vColor;
out vec4 vTexCoord;

void main(void)
{
    gl_Position = vec4(aVertex, 1) * uUser;
    vColor = aColor;
    vTexCoord = vec4(aTexCoord0, 0);

    // aTexCoord0.z にはシートインデックスが格納されていますが、
    // この値がマイナスの場合、影用の文字描画であることを表します。
    if (aTexCoord0.z < 0)
    {
        // ピクセルシェーダでは頂点カラーのアルファ値がマイナスで
        // あることが影用の文字であることを表すので、符号を反転します。
        // aColor.a は符号なし１バイト整数値で送られてくるので、
        // 頂点シェーダでマイナスにします。
        // この判定を頂点シェーダで行っているのは、ピクセルシェーダの
        // 処理負荷を少しでも重くならないようにするためです。
        vColor.a = -vColor.a;
        vTexCoord.z = -vTexCoord.z - 1;
    }
}

