﻿Param($Path)
Add-Type -Language CSharpVersion3 -TypeDefinition @"

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

public class Program
{
    // System.Tuple が使えないため、簡易実装
    class Tuple<T1, T2, T3>
    {
        public T1 Item1 { get; set; }
        public T2 Item2 { get; set; }
        public T3 Item3 { get; set; }
    }

    class Tuple
    {
        public static Tuple<T1, T2, T3> Create<T1, T2, T3>(T1 x1, T2 x2, T3 x3)
        {
            var ret = new Tuple<T1, T2, T3>();
            ret.Item1 = x1;
            ret.Item2 = x2;
            ret.Item3 = x3;
            return ret;
        }
    }

    public static void Update(string path)
    {
        var lines = File.ReadAllLines(path).ToArray();
        var headers = new List<string>();
        var i = 0;
        while (!lines[i].TrimStart().StartsWith(@"GlobalSection"))
        {
            headers.Add(lines[i]);
            ++i;
        }
        while (!lines[i].TrimStart().StartsWith(@"EndGlobalSection"))
        {
            ++i;
        }
        while (!lines[i].TrimStart().StartsWith(@"GlobalSection"))
        {
            ++i;
        }
        while (!lines[i].TrimStart().StartsWith(@"EndGlobalSection"))
        {
            ++i;
        }
        var footers = new List<string>();
        for (; i < lines.Length; ++i)
        {
            footers.Add(lines[i]);
        }

        var css = from line in headers
                  where line.IndexOf(@"FAE04EC0-301F-11D3-BF4B-00C04F79EFBC") >= 0
                  select line.Substring(line.Length - 39, 38);
        var cxxs = from line in headers
                   where line.IndexOf(@"8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942") >= 0
                   select line.Substring(line.Length - 39, 38);

        var pres = new List<string>();
        var posts3 = new List<Tuple<string, string, string>>();
        foreach (var d in new[] { "Debug", "Develop", "Release" })
        {
            foreach (var nx in new[] { "NX64", "NX32" })
            {
                var p = nx;
                pres.Add(string.Format("\t\t{0}|{1} = {0}|{1}", d, p));
                posts3.Add(Tuple.Create(d, p, string.Format(@"NX_{0}|{1}", d, p)));
            }
        }

        var results = new List<string>();
        results.AddRange(headers);
        results.Add("\tGlobalSection(SolutionConfigurationPlatforms) = preSolution");
        results.AddRange(pres);
        results.Add("\tEndGlobalSection");
        results.Add("\tGlobalSection(ProjectConfigurationPlatforms) = postSolution");
        foreach (var cs in css)
        {
            foreach (var post in posts3)
            {
                var d = post.Item1;
                if (d == "Develop")
                {
                    d = "Debug";
                }
                results.Add(string.Format("\t\t{0}.{1}|{2}.ActiveCfg = {3}|Any CPU", cs, post.Item1, post.Item2, d));
                results.Add(string.Format("\t\t{0}.{1}|{2}.Build.0 = {3}|Any CPU", cs, post.Item1, post.Item2, d));
            }
        }
        foreach (var cxx in cxxs)
        {
            foreach (var post in posts3)
            {
                results.Add(string.Format("\t\t{0}.{1}|{2}.ActiveCfg = {3}", cxx, post.Item1, post.Item2, post.Item3));
                results.Add(string.Format("\t\t{0}.{1}|{2}.Build.0 = {3}", cxx, post.Item1, post.Item2, post.Item3));
            }
        }
        results.AddRange(footers);

        File.WriteAllLines(path, results.ToArray(), Encoding.UTF8);
    }
}

"@

[Program]::Update($Path)
