﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_SessionApi.h>

#include <string>
#include <nn/nn_SdkAssert.h>
#include <nn/web/detail/web_SessionApiDetail.h>
#include <nn/web/detail/web_SessionMessageTypesDetail.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
size_t Session::GetWorkBufferSize() NN_NOEXCEPT
{
    return sizeof(detail::SessionImpl);
}

//------------------------------------------------------------------------
Session::Session() NN_NOEXCEPT
: m_pImpl()
{
}

//------------------------------------------------------------------------
void Session::Initialize(void* pWorkBuffer, size_t workBufferSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pWorkBuffer);
    NN_SDK_REQUIRES_ALIGNED(pWorkBuffer, 4);
    NN_SDK_REQUIRES(workBufferSize == GetWorkBufferSize());

    auto impl = new(pWorkBuffer) detail::SessionImpl();
    m_pImpl = impl;
}

//------------------------------------------------------------------------
void Session::Finalize() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(m_pImpl);

    auto impl = reinterpret_cast<detail::SessionImpl*>(m_pImpl);
    impl->~SessionImpl();
    m_pImpl = nullptr;
}

//------------------------------------------------------------------------
bool Session::IsValid() const NN_NOEXCEPT
{
    return m_pImpl != nullptr;
}

//------------------------------------------------------------------------
bool Session::TryReciveMessage(SessionMessage* pOutMessage) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutMessage);

    if (!IsValid())
    {
        return false;
    }

    auto impl = reinterpret_cast<detail::SessionImpl*>(m_pImpl);
    return impl->tryRecive(pOutMessage);
}

//------------------------------------------------------------------------
void* Session::Impl()
{
    return m_pImpl;
}

}} // namespace nn::web
