﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_LoginShowArgPrivate.h>

#include <string>

#include <nn/applet/applet_Types.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>

namespace nn { namespace web {

// enum値一致のチェック
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_EndButtonPressed) == static_cast<int>(web::common::ExitReason::EndButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_BackButtonPressed) == static_cast<int>(web::common::ExitReason::BackButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_ExitMessage) == static_cast<int>(web::common::ExitReason::ExitMessage));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_CallbackUrlReached) == static_cast<int>(web::common::ExitReason::CallbackUrlReached));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_LastWindowDeleted) == static_cast<int>(web::common::ExitReason::LastWindowDeleted));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_LocalNetworkDisconnectionDenied) == static_cast<int>(web::common::ExitReason::LocalNetworkDisconnectionDenied));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_MediaPlayerClosed) == static_cast<int>(web::common::ExitReason::MediaPlayerClosed));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_CausedByWebPage) == static_cast<int>(web::common::ExitReason::CausedByWebPage));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_UserSelectionCanceled) == static_cast<int>(web::common::ExitReason::UserSelectionCanceled));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_NetworkConnectionFailed) == static_cast<int>(web::common::ExitReason::NetworkConnectionFailed));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_SystemUpdateRequired) == static_cast<int>(web::common::ExitReason::SystemUpdateRequired));
NN_STATIC_ASSERT(static_cast<int>(LoginExitReason_Unexpected) == static_cast<int>(web::common::ExitReason::Unexpected));

//------------------------------------------------------------------------
ShowLoginPageArg::ShowLoginPageArg() NN_NOEXCEPT
: m_Data()
{
    // 初期化
    nn::web::common::CommonArgData::InitializeData(m_Data, nn::web::common::ShimKind::Login);

    // 左スティックモードを空間ナビへ変更する
    // refs; BROWSER1-550
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::LeftStickMode, common::LeftStickMode::SpatialNavi);

    // Uidを無効値にする
    SetUid(nn::account::InvalidUid);

    // ページ情報ダイアログの URL 表記をドメインに
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseDommainForPageInfo, true);

    // コンテンツ欠落を禁止する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsContentsDropDisabled, true);

    // 再起動ダイアログを抑制する
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::SuppressRestartDialog, true);

    // 起動画面を呼び出し元画像にする
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootDisplayKind, common::BootDisplayKind::CallerCapture);

    // デフォルトでアノニマスモードにする
    const bool isAnonymousMode = true;
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsAnonymousMode, isAnonymousMode);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetRequestUrl(const char* pRequestUrl) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::RequestURL, RequestUrlMaxLength, pRequestUrl);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetCallbackUrl(const char* pCallbackUrl) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::CallbackURL, CallbackUrlMaxLength, pCallbackUrl);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetCallbackableUrl(const char* pCallbackableUrl) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::CallbackableURL, CallbackableUrlMaxLength, pCallbackableUrl);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetUid(const nn::account::Uid& uid) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::Uid, uid);

    // 有効なUidだったらアカウントモード(非アノニマス)にし
    // 無効なUidだったらアノニマスモードにする
    const bool isAnonymousMode = (uid == nn::account::InvalidUid);
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsAnonymousMode, isAnonymousMode);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetClearCookieAndLocalStorage(const bool clearCookieAndLocalStorage) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::ClearCookieAndLocalStorage, clearCookieAndLocalStorage);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetClearCookieAndLocalStorageExceptNintendoAccount(const bool clearCookieAndLocalStorageExceptNintendoAccount) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::ClearCookieAndLocalStorageExceptNintendoAccount, clearCookieAndLocalStorageExceptNintendoAccount);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetPointerEnabled(const bool pointerEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseStickPointer, pointerEnabled);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetRightStickSpatialNavigationEnabled(const bool enabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseRightStickSpatialNavi, enabled);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::PushToInChannel(nn::applet::LibraryAppletHandle handle) const NN_NOEXCEPT
{
    nn::web::common::CommonApi::PushStorageToInChannel(handle, m_Data, DataSize);
}

//------------------------------------------------------------------------
void ShowLoginPageArg::SetBootFooterButtonVisible(const LoginFooterButtonId buttonId, const bool visible) NN_NOEXCEPT
{
    common::CommonApi::SetBootFooterButtonVisible(m_Data, common::FooterButtonId(buttonId), visible);
}

//------------------------------------------------------------------------
LoginPageReturnValue::LoginPageReturnValue() NN_NOEXCEPT
: m_ExitReason()
, m_LastUrl()
, m_LastUrlSize()
{
}

//------------------------------------------------------------------------
LoginExitReason LoginPageReturnValue::GetLoginExitReason() const NN_NOEXCEPT
{
    return static_cast<LoginExitReason>(m_ExitReason);
}

//------------------------------------------------------------------------
const char* LoginPageReturnValue::GetLastUrl() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == LoginExitReason_CallbackUrlReached);
    return m_LastUrl;
}

//------------------------------------------------------------------------
size_t LoginPageReturnValue::GetLastUrlSize() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == LoginExitReason_CallbackUrlReached);
    return size_t(m_LastUrlSize);
}

}} // namespace nn::web
