﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_LoginApiPrivate.h>

#include <nn/applet/applet_Types.h>
#include <nn/la/la_CommonArgumentsWriter.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_LoginTypesDetail.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
nn::Result ShowLoginPage(LoginPageReturnValue* pOutputLoginPageReturnValue,
    const ShowLoginPageArg& arg) NN_NOEXCEPT
{
    auto handle = nn::web::common::CommonApi::PrepareLibraryApplet(applet::AppletId_LibraryAppletLoginShare);

    // 共通引数をプッシュ
    nn::la::CommonArgumentsWriter writer(nn::web::common::ShimVersion, detail::LoginShimVersion);
    writer.PushToInChannel(handle);

    // ログインページを開くための起動引数をプッシュ
    arg.PushToInChannel(handle);

    // ログインページを開く
    return nn::web::common::CommonApi::StartLibraryAppletAndWait(pOutputLoginPageReturnValue, sizeof(*pOutputLoginPageReturnValue), handle);
}

//------------------------------------------------------------------------
nn::Result GetLoginPageReturnValueFromStorage(LoginPageReturnValue* pOutputLoginPageReturnValue,
    const nn::applet::StorageHandle& handle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutputLoginPageReturnValue);
    nn::web::common::CommonApi::ReadFromStorage(
        pOutputLoginPageReturnValue, sizeof(*pOutputLoginPageReturnValue), handle);
    return nn::ResultSuccess();
}

}} // namespace nn::web
