﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationRecordApi.h>
#include <nn/ns/ns_ApplicationViewApi.h>
#include <nn/result/result_HandlingUtility.h>
#include "detail/rid_Settings.h"

namespace nn { namespace rid {

    int ListApplication(ncm::ApplicationId outApplicationIdList[], int count, bool excludeNoRightsContent) NN_NOEXCEPT
    {
        std::unique_ptr<ns::ApplicationRecord> records(new ns::ApplicationRecord[count]);
        int listedCount = ns::ListApplicationRecord(records.get(), count, 0);

        int launchableCount = 0;
        for (int i = 0; i < listedCount; i++)
        {
            ns::ApplicationView view;
            ncm::ApplicationId id = (records.get() + i)->id;
            NN_RESULT_DO(ns::GetApplicationView(&view, &id, 1));

            // 条件を満たす id をリストに追加する
            if (view.IsLaunchable()                                                                                             // Launchable である
                && id != GetMenuApplicationId()                                                                                 // 試遊台メニューではない
                && (!excludeNoRightsContent || (excludeNoRightsContent && ns::CheckApplicationLaunchRights(id).IsSuccess())))   // 権利が無いコンテンツを除外するオプションが無効 または 有効で権利チェックが成功
            {
                outApplicationIdList[launchableCount] = id;
                launchableCount++;
            }
        }

        return launchableCount;
    }
}}
