﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <glv.h>
#include <glv_binding.h>
#include <glv_resources.h>
#include <nv/nv_MemoryManagement.h>
#include <nvnTool/nvnTool_GlslcInterface.h>
#include <nn/repair/repair_LabelButton.h>

namespace nn {
    namespace repair {
        bool LabelButton::onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT
        {
            switch (e)
            {
            case glv::Event::WindowCreate:
            {
                if (m_WindowCreateHandler != nullptr)
                {
                    m_WindowCreateHandler();
                }
            }
            break;
            case glv::Event::WindowDestroy:
            {
                if (m_WindowDestroyHandler != nullptr)
                {
                    m_WindowDestroyHandler();
                }
            }
            break;
            case glv::Event::MouseDown:
            {
                if (m_MouseDownHandler != nullptr)
                {
                    m_MouseDownHandler();
                }
            }
            break;
            default:
                break;
            }
            return true;
        }

        glv::Label* LabelButton::FitButton(glv::Label* pLabel, float fontSize, glv::space_t padding) NN_NOEXCEPT
        {
            pLabel->size(fontSize);
            pLabel->paddingX(padding);
            pLabel->paddingY(padding);
            pLabel->pos(glv::Place::CC, 0, 0).anchor(glv::Place::CC);
            glv::space_t width = (pLabel->width() + 1.f) / 2.f * 2.f;
            glv::space_t height = (pLabel->height() + 1.f) / 2.f * 2.f;
            glv::Button::extent(width, height);
            return pLabel;
        }
    }
}
