﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include "..\..\..\Include\nn\repair\repair_FileSystem.h"
#include <map>
#include <nn/nn_SdkLog.h>
#include <nn/TargetConfigs/build_Os.h>

namespace nn
{
namespace repair
{

namespace
{
}

nn::repair::FileSystem* CreateNnfsFileSystem();
nn::repair::FileSystem* CreateManuFileSystem();

std::shared_ptr<FileSystem> nn::repair::FileSystem::Create(const char* type)
{
    if (std::string(type) == "nnfs")
    {
        return std::shared_ptr<FileSystem>(CreateNnfsFileSystem());
    }

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    if (std::string(type) == "manu")
    {
        return std::shared_ptr<FileSystem>(CreateManuFileSystem());
    }
#endif

    NN_ABORT("unknown filesystem type: %s", type);
    return nullptr;
}

}
}
