﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Result.h>
#include <nn/repair.h>
#include <nn/repair/repair_CryptUtility.h>
#include <nn/repair/repair_FileSystem.h>
#include <nn/repair/repair_ProtectedFile.h>
#include <string>
#include "repair_BlackList.h"
#include "repair_Record.h"

namespace nn { namespace repair { namespace detail {

//!< データ抽出を扱うクラスです。解析用
class UnsafeExtract final
{

private:

    std::string m_OutputPath;

public:
    explicit UnsafeExtract(const std::string& path) NN_NOEXCEPT
         : m_OutputPath(path)
    {
        SetRecordDirectoryPath(path.c_str());
    }

    //!< データをエクスポートします。
    nn::Result Export() const NN_NOEXCEPT;

private:

    //!< システムセーブデータをエクスポートします。
    nn::Result ExportSystemData() const NN_NOEXCEPT;

    //!< ユーザセーブデータをエクスポートします。
    nn::Result ExportUserData() const NN_NOEXCEPT;

    //!< サムネイルデータをエクスポートします。
    nn::Result ExportThumbnailData() const NN_NOEXCEPT;

    //!< アルバムデータをエクスポートします。
    nn::Result ExportAlbumData() const NN_NOEXCEPT;

};

}}} // namespace nn::repair::detail

