﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include "../repair_Utility.h"
#include "repair_Directory.h"

namespace nn { namespace repair { namespace detail {

bool Directory::IsFound() const NN_NOEXCEPT
{
    nn::fs::DirectoryEntryType type;
    return nn::fs::GetEntryType(&type, m_Path.c_str()).IsSuccess();
}

nn::Result Directory::Create() const NN_NOEXCEPT
{
    NN_REPAIR_RESULT_DO(nn::fs::CreateDirectory(m_Path.c_str()));
    NN_RESULT_SUCCESS;
}

nn::Result Directory::Delete() const NN_NOEXCEPT
{
    NN_REPAIR_RESULT_DO(nn::fs::DeleteDirectoryRecursively(m_Path.c_str()));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::repair::detail

