﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/g3d/res/g3d_ResSkeleton.h>

NW_G3D_PRAGMA_PUSH_WARNINGS
NW_G3D_DISABLE_WARNING_SHADOW

namespace nw { namespace g3d { namespace res {

int ResSkeleton::GetBranchEndIndex(int boneIndex) const
{
    // ResBone が深さ優先で格納されていることに依存する。
    // 同じ枝を辿っている間は元の親より小さなインデックスを持つことは無い。
    int numBone = GetBoneCount();
    int branchParentIndex = GetBone(boneIndex)->GetParentIndex();
    if (boneIndex == 0)
    {
        // ルートノードは全てのノードを辿るので、branchParentIndex = -1。
        branchParentIndex = -1;
    }
    for (++boneIndex; boneIndex < numBone; ++boneIndex)
    {
        if (GetBone(boneIndex)->GetParentIndex() <= branchParentIndex)
        {
            return boneIndex;
        }
    }
    return boneIndex;
}

void ResSkeleton::UpdateBillboardMode()
{
    for (int idxBone = 0, numBone = GetBoneCount(); idxBone < numBone; ++idxBone)
    {
        ResBone* pBone = GetBone(idxBone);
        bit32 bbMode = pBone->GetBillboardMode();

        if (bbMode >= ResBone::BILLBOARD_WORLD_VIEWVECTOR)
        {
            // 子がいる場合は階層ビルボードを行う。
            if (idxBone + 1 < numBone && idxBone == GetBone(idxBone + 1)->GetParentIndex())
            {
                pBone->ref().billboardIndex = static_cast<u16>(idxBone); // 自分自身が参照先。
            }
            else
            {
                pBone->ref().billboardIndex = ResBone::BB_INDEX_NONE;
            }
        }
        else
        {
            pBone->ref().flag &= ~ResBone::BILLBOARD_MASK; // 確実に BILLBOARD_NONE にする。
            if (idxBone == 0)
            {
                pBone->ref().billboardIndex = ResBone::BB_INDEX_NONE;
                continue;
            }

            ResBone* pParent = GetBone(pBone->GetParentIndex());
            pBone->ref().billboardIndex = pParent->ref().billboardIndex;

            // 親が階層ビルボードの場合は引き継ぐ。
            if (pParent->ref().billboardIndex != ResBone::BB_INDEX_NONE)
            {
                pBone->ref().flag |= ResBone::BILLBOARD_CHILD;
            }
        }
    }
}

}}} // namespace nw::g3d::res

NW_G3D_PRAGMA_POP_WARNINGS
