﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/g3d/res/g3d_ResShape.h>
#include <limits>
#include <nw/g3d/res/g3d_ResFile.h>
#include <nw/g3d/fnd/g3d_GLUtility.h>
#include <nw/g3d/fnd/g3d_GX2Utility.h>

NW_G3D_PRAGMA_PUSH_WARNINGS
NW_G3D_DISABLE_WARNING_SHADOW

namespace nw { namespace g3d { namespace res {

void ResBuffer::Setup()
{
    GfxBuffer* vBuffer = this->GetGfxBuffer();
    vBuffer->SetData(this->GetData(), static_cast<u32>(this->GetSize()));
    vBuffer->Setup();
    vBuffer->DCFlush();
}

void ResBuffer::Cleanup()
{
    GfxBuffer* vBuffer = this->GetGfxBuffer();
    vBuffer->SetData(NULL, static_cast<u32>(this->GetSize()));
    vBuffer->Cleanup();
}

//--------------------------------------------------------------------------------------------------

void ResVertex::Setup()
{
    for (int idxBuffer = 0, numBuffer = GetVtxBufferCount(); idxBuffer < numBuffer; ++idxBuffer)
    {
        this->GetVtxBuffer(idxBuffer)->Setup();
    }
}

void ResVertex::Cleanup()
{
    for (int idxBuffer = 0, numBuffer = GetVtxBufferCount(); idxBuffer < numBuffer; ++idxBuffer)
    {
        this->GetVtxBuffer(idxBuffer)->Cleanup();
    }
}

void ResVertex::Reset()
{
    ref().pUserPtr.set_ptr(NULL);
}

//--------------------------------------------------------------------------------------------------

void ResShape::Setup()
{
    for (int idxMesh = 0, numMesh = GetMeshCount(); idxMesh < numMesh; ++idxMesh)
    {
        ResMesh* mesh = this->GetMesh(idxMesh);
        ResBuffer* buffer = mesh->GetIdxBuffer();
        GfxBuffer* idxBuffer = buffer->GetGfxBuffer();
        idxBuffer->SetData(buffer->GetData(), static_cast<u32>(buffer->GetSize()));
        idxBuffer->Setup();
        idxBuffer->DCFlush();
    }
}

void ResShape::Cleanup()
{
    for (int idxMesh = 0, numMesh = GetMeshCount(); idxMesh < numMesh; ++idxMesh)
    {
        ResMesh* mesh = this->GetMesh(idxMesh);
        ResBuffer* buffer = mesh->GetIdxBuffer();
        GfxBuffer* idxBuffer = buffer->GetGfxBuffer();
        idxBuffer->SetData(NULL, static_cast<u32>(buffer->GetSize()));
        idxBuffer->Cleanup();
    }
}

void ResShape::Reset()
{
    ref().pUserPtr.set_ptr(NULL);
}

void ResMesh::DrawSubMesh(int submeshIndex, int submeshCount, int instances /*= 1*/) const
{
    NW_G3D_ASSERT(GX2_PRIMITIVE_POINTS <= ref().primType &&
        ref().primType <= GX2_PRIMITIVE_QUAD_STRIP);
    NW_G3D_ASSERT(submeshCount > 0);
    NW_G3D_ASSERT(instances > 0);

    u32 strideShift = (GetIndexFormat() & 0x1) + 1; // u16 -> 1, u32 -> 2
    const ResSubMesh* pFirstSubMesh = GetSubMesh(submeshIndex);
    u32 offset = pFirstSubMesh->GetOffset();
    // offset はバイト換算なので count 計算時には個数に戻す。
    const ResSubMesh* pLastSubMesh = GetSubMesh(submeshIndex + submeshCount - 1);
    u32 count = ((pLastSubMesh->GetOffset() - offset) >> strideShift) + pLastSubMesh->GetCount();

#if NW_G3D_IS_GX2
    GX2PrimitiveType primType = GetPrimitiveType();
    GX2IndexFormat format = GetIndexFormat();
    const GfxBuffer* pIdxBuffer = GetIdxBuffer()->GetGfxBuffer();
    GX2DrawIndexedEx(primType, count, format,
        AddOffset(pIdxBuffer->GetData(), offset), ref().offset, instances);
#elif NW_G3D_IS_GL && !defined( NW_STRIP_GL )
    GetIdxBuffer()->GetGfxBuffer()->LoadIndices();
    const GLPrimitiveType& primType = FindGLPrimitiveType(GetPrimitiveType());
    u32 format = GetIndexFormat() == GX2_INDEX_FORMAT_U16 ? GL_UNSIGNED_SHORT : GL_UNSIGNED_INT;

#if !defined(NW_G3D_IS_GL_ES)
    glDrawElementsInstancedBaseVertex(primType.drawType, count, format,
        reinterpret_cast<void*>(offset), instances, ref().offset);
#else
    NW_G3D_ASSERTMSG(ref().offset == 0, "NW: not supported offset != 0");
    glDrawElementsInstanced(primType.drawType, count, format,
        reinterpret_cast<void*>(offset), instances);
#endif
    NW_G3D_GL_ASSERT();
#else
    NW_G3D_UNUSED(submeshIndex);
    NW_G3D_UNUSED(instances);
    NW_G3D_UNUSED( count );
#endif
}

}}} // namespace nw::g3d::res

NW_G3D_PRAGMA_POP_WARNINGS
