﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditWorkBuffer.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/fnd/g3d_GfxManage.h>

namespace nw { namespace g3d { namespace edit { namespace ut { namespace detail {

bool EditWorkBuffer::ResizeImpl(size_t size)
{
    if (size == 0)
    {
        Clear();
        return true;
    }

    void* newBuffer = m_pAllocator->Alloc(size, m_Alignment);
    if (newBuffer == NULL)
    {
        return false;
    }

    if (m_pWorkBuffer != NULL)
    {
        m_pAllocator->Free(m_pWorkBuffer);
    }

    m_pWorkBuffer = newBuffer;
    m_WorkBufferSize = size;
    return true;
}

bool
EditWorkBuffer::Resize(size_t size)
{
    if (size == m_WorkBufferSize)
    {
        return true;
    }

    return ResizeImpl(size);
}

bool EditWorkBuffer::Resize(size_t size, size_t alignment)
{
    if (size == m_WorkBufferSize && alignment == m_Alignment)
    {
        return true;
    }

    m_Alignment = alignment;
    return ResizeImpl(size);
}

void
EditWorkBuffer::CopyAndFlush(const void* pBuffer, size_t size)
{
    NW_G3D_ASSERT((size % sizeof(bit32)) == 0);
    NW_G3D_ASSERT(m_WorkBufferSize >= size);
    nw::g3d::ut::Copy32<false>(m_pWorkBuffer, pBuffer, size / sizeof(bit32));
    nw::g3d::fnd::CPUCache::Flush(m_pWorkBuffer, size);
}

void EditWorkBuffer::Flush()
{
    if (m_pWorkBuffer != NULL)
    {
        nw::g3d::fnd::CPUCache::Flush(m_pWorkBuffer, m_WorkBufferSize);
    }
}

}}}}} // namespace nw::g3d::edit::ut::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
