﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditVisibilityAnimObj.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/g3d_IAllocator.h>

namespace nw { namespace g3d { namespace edit { namespace detail {

/*virtual*/bool
EditVisibilityAnimObj::CreateDataForEditingAnimCurve()
{
    ResVisibilityAnim* pResAnim = static_cast<ResVisibilityAnim*>(GetResAnim());
    int curveCount = pResAnim->GetCurveCount();
    size_t bufferSize = sizeof(EditAnimCurve) * curveCount;

    void* buffer = NULL;
    if (bufferSize > 0)
    {
        buffer = m_pAllocator->Alloc(bufferSize, DEFAULT_ALIGNMENT);
        if (buffer == NULL)
        {
            return false;
        }
    }

    m_pEditAnimCurveArray = static_cast<EditAnimCurve*>(buffer);
    m_EditAnimCurveCount = curveCount;

    for(int i = 0; i < m_EditAnimCurveCount; ++i)
    {
        nw::g3d::res::ResAnimCurve* resAnimCurve = pResAnim->GetCurve(i);

        EditAnimCurve* editAnimCurve = new (&m_pEditAnimCurveArray[i]) EditAnimCurve(i, m_pAllocator, resAnimCurve);
        editAnimCurve->Setup();
    }
    return true;
}

/*virtual*/void
EditVisibilityAnimObj::DestroyDataForEditingAnimCurve()
{
    for(int i = 0; i < m_EditAnimCurveCount; ++i)
    {
        EditAnimCurve* editAnimCurve = &m_pEditAnimCurveArray[i];
        editAnimCurve->Cleanup();
    }

    m_EditAnimCurveCount = 0;
    if (m_pEditAnimCurveArray != NULL)
    {
        m_pAllocator->Free(m_pEditAnimCurveArray);
        m_pEditAnimCurveArray = NULL;
    }
}

/*virtual*/bool
EditVisibilityAnimObj::SetupInternal(ModelObj* pBindTargetModelObj, ModelAnimObj* pBoundAnimObj)
{
    BindResult result;
    ResModel* pResModel = pBindTargetModelObj->GetResource();
    VisibilityAnimObj* pAnimObj = static_cast<VisibilityAnimObj*>(pBoundAnimObj);
    ResVisibilityAnim* pResAnim = static_cast<ResVisibilityAnim*>(GetResAnim());

    VisibilityAnimObj::InitArg initArg;
    initArg.DisableContext();
    initArg.Reserve(pBindTargetModelObj->GetResource());
    initArg.Reserve(pResAnim);

    size_t bufferSize = VisibilityAnimObj::CalcBufferSize(initArg);
    void* buffer = m_pAllocator->Alloc(bufferSize, VisibilityAnimObj::BUFFER_ALIGNMENT);
    NW_G3D_ASSERT_NOT_NULL_DETAIL(buffer, "%s\n", NW_G3D_RES_GET_NAME(pResModel, GetName()));//今は止める
    pAnimObj->Init(initArg, buffer, bufferSize);
    pAnimObj->SetResource(pResAnim);
    result = pAnimObj->Bind(pBindTargetModelObj);

    return !result.IsMissed();// 一つでもバインドされていれば成功
}

void
EditVisibilityAnimObj::EditCurve(
    int curveIndex,
    const nw::g3d::res::ResAnimCurve* resAnimCurve,
    u32 resAnimCurveSize
    )
{
    ResVisibilityAnim* pResAnim = static_cast<ResVisibilityAnim*>(GetResAnim());
    NW_G3D_ASSERTMSG(curveIndex != -1, "%s\n", NW_G3D_RES_GET_NAME(pResAnim, GetName()));

    int curveCount = pResAnim->GetCurveCount();
    if (curveIndex >= curveCount)
    {
        NW_G3D_EDIT_WARNING_INDEX_BOUNDS(curveIndex, curveCount);
        return;
    }

    EditAnimCurve* editAnimCurve = &m_pEditAnimCurveArray[curveIndex];
    editAnimCurve->Edit(resAnimCurve->ptr(), resAnimCurveSize);
}

/*virtual*/void
EditBoneVisibilityAnimObj::ResetToOriginalValue(ModelObj* pBoundModelObj)
{
    if (!IsModelBound(pBoundModelObj))
    {
        return;
    }

    pBoundModelObj->ClearBoneVisibility();
}

/*virtual*/void
EditMatVisibilityAnimObj::ResetToOriginalValue(ModelObj* pBoundModelObj)
{
    if (!IsModelBound(pBoundModelObj))
    {
        return;
    }

    pBoundModelObj->ClearMatVisibility();
}

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
