﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

namespace nw { namespace g3d {

namespace res {

class ResShaderParamAnim;

} // namespace res

class ModelObj;
class ShaderParamAnimObj;

}} // namespace nw::g3d

namespace nw { namespace g3d { namespace edit {

namespace detail {

bool EditMaterials(ModelObj* modelObj, const EditMaterialArg& arg);
bool EditBones(ModelObj* modelObj, const EditBoneArg& arg);
bool EditRenderInfoArraySize(ModelObj* modelObj, const char* labelName, const RenderInfoEditInfo* info);
void SetShaderParamAnimationCurve(ResShaderParamAnim* resShaderParamAnim, int materialIndex);
const char* GetEditCommandString(CommandFlag command);
const char* GetResName(ResFile* pResFile, FileDataKind kind);
const char* GetFileDataKindString(FileDataKind kind);
const char* GetAnimKindString(EditAnimKind kind);
FileDataKind ConvertToFileDataKind(nw::g3d::edit::EditAnimKind kind);

inline u32 GetResFileKeyFromResFile(const ResFile* pResFile)
{
    return reinterpret_cast<u32>(pResFile);
}

inline ResFile* GetResFileFromResFileKey(u32 resFileKey)
{
    return reinterpret_cast<ResFile*>(resFileKey);
}

inline u32 GetKeyFromModelObj(const ModelObj* pModelObj)
{
    return reinterpret_cast<u32>(pModelObj);
}

inline ModelObj* GetModelObjFromKey(u32 key)
{
    return reinterpret_cast<ModelObj*>(key);
}

inline u32 GetResModelKeyFromResModel(const ResModel* pResModel)
{
    return reinterpret_cast<u32>(pResModel);
}

inline u32 GetKeyFromResShaderArchive(const ResShaderArchive* pResShaderArchive)
{
    return reinterpret_cast<u32>(pResShaderArchive);
}

class Endian
{
public:
    //データのエンディアンを反転します。
    static void Swap(bit32* data)
    {
        nw::g3d::ut::StoreRevU32(data, *data);
    }
private:
    static void Swap(bit16* data)
    {
        nw::g3d::ut::StoreRevU16(data, *data);
    }

    static void Swap(f32* data)
    {
        union
        {
            f32* f32;
            bit32* bit32;
        } ptr = { data };
        Swap(ptr.bit32);
    }

    static void Swap(s32* data)
    {
        union
        {
            s32* s32;
            bit32* bit32;
        } ptr = { data };
        Swap(ptr.bit32);
    }
};

} // namespace ut

}}} // namespace nw::g3d::edit

#endif // NW_G3D_CONFIG_USE_HOSTIO
