﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditShapeAnimObj.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/g3d_IAllocator.h>

namespace nw { namespace g3d { namespace edit { namespace detail {

bool
EditShapeAnimObj::EditVertexShapeAnim::Init()
{
    int curveCount = m_pResVertexShapeAnim->GetCurveCount();
    size_t bufferSize = sizeof(EditAnimCurve) * curveCount;

    void* buffer = m_pAllocator->Alloc(bufferSize, DEFAULT_ALIGNMENT);
    if (buffer == NULL)
    {
        return false;
    }
    m_pEditAnimCurveArray = static_cast<EditAnimCurve*>(buffer);
    m_EditAnimCurveCount = curveCount;

    for(int i = 0; i < m_EditAnimCurveCount; ++i)
    {
        nw::g3d::res::ResAnimCurve* resAnimCurve =
            m_pResVertexShapeAnim->GetCurve(i);

        EditAnimCurve* editAnimCurve = new(&m_pEditAnimCurveArray[i]) EditAnimCurve(i, m_pAllocator, resAnimCurve);
        editAnimCurve->Setup();
    }
    return true;
}

void
EditShapeAnimObj::EditVertexShapeAnim::Destroy()
{
    for(int i = 0; i < m_EditAnimCurveCount; ++i)
    {
        EditAnimCurve* editAnimCurve = &m_pEditAnimCurveArray[i];
        editAnimCurve->Cleanup();
    }

    if (m_pEditAnimCurveArray != NULL)
    {
        m_pAllocator->Free(m_pEditAnimCurveArray);
        m_pEditAnimCurveArray = NULL;
    }
}

/*virtual*/void
EditShapeAnimObj::ResetToOriginalValue(ModelObj* pBoundModelObj)
{
    NW_G3D_UNUSED(pBoundModelObj);
}

/*virtual*/bool
EditShapeAnimObj::CreateDataForEditingAnimCurve()
{
    ResShapeAnim* pResAnim = static_cast<ResShapeAnim*>(GetResAnim());
    int animCount = pResAnim->GetVertexShapeAnimCount();
    size_t bufferSize = sizeof(EditShapeAnimObj::EditVertexShapeAnim) * animCount;

    void* buffer = NULL;
    if (bufferSize > 0)
    {
        buffer = m_pAllocator->Alloc(bufferSize, DEFAULT_ALIGNMENT);
        if (buffer == NULL)
        {
            return false;
        }
    }

    m_pEditVertexShapeAnimArray = static_cast<EditShapeAnimObj::EditVertexShapeAnim*>(buffer);
    m_EditVertexShapeAnimCount = animCount;

    bool isFailed = false;
    for(int i = 0; i < m_EditVertexShapeAnimCount; ++i)
    {
        nw::g3d::res::ResVertexShapeAnim* resVertexShapeAnim = pResAnim->GetVertexShapeAnim(i);

        EditShapeAnimObj::EditVertexShapeAnim* editShapeAnim = new(&m_pEditVertexShapeAnimArray[i]) EditShapeAnimObj::EditVertexShapeAnim(m_pAllocator, resVertexShapeAnim);
        isFailed = !editShapeAnim->Init();
    }

    // 初期化失敗のものが一つでもあった場合は、インスタンスを破棄して失敗にする。
    if (isFailed)
    {
        DestroyDataForEditingAnimCurve();
        return false;
    }

    return true;
}

/*virtual*/void
EditShapeAnimObj::DestroyDataForEditingAnimCurve()
{
    for(int i = 0; i < m_EditVertexShapeAnimCount; ++i)
    {
        EditShapeAnimObj::EditVertexShapeAnim* editVertexShapeAnim = &m_pEditVertexShapeAnimArray[i];
        editVertexShapeAnim->Destroy();
    }

    m_EditVertexShapeAnimCount = 0;

    if (m_pEditVertexShapeAnimArray != NULL)
    {
        m_pAllocator->Free(m_pEditVertexShapeAnimArray);
        m_pEditVertexShapeAnimArray = NULL;
    }
}

/*virtual*/bool
EditShapeAnimObj::SetupInternal(ModelObj* pBindTargetModelObj, ModelAnimObj* pBoundAnimObj)
{
    ResModel* pResModel = pBindTargetModelObj->GetResource();
    ShapeAnimObj* pAnimObj = static_cast<ShapeAnimObj*>(pBoundAnimObj);
    ResShapeAnim* pResAnim = static_cast<ResShapeAnim*>(GetResAnim());

    ShapeAnimObj::InitArg initArg;
    initArg.DisableContext();
    initArg.Reserve(pBindTargetModelObj->GetResource());
    initArg.Reserve(pResAnim);

    size_t bufferSize = ShapeAnimObj::CalcBufferSize(initArg);
    void* buffer = m_pAllocator->Alloc(bufferSize, ShapeAnimObj::BUFFER_ALIGNMENT);
    NW_G3D_ASSERT_NOT_NULL_DETAIL(buffer, "%s\n", NW_G3D_RES_GET_NAME(pResModel, GetName()));//今は止める
    pAnimObj->Init(initArg, buffer, bufferSize);
    pAnimObj->SetResource(pResAnim);
    nw::g3d::res::BindResult result = pAnimObj->Bind(pBindTargetModelObj);

    return !result.IsMissed();// 一つでもバインドされていれば成功
}

void
EditShapeAnimObj::EditCurve(
    int animIndex,
    int curveIndex,
    const nw::g3d::res::ResAnimCurve* resAnimCurve,
    u32 resAnimCurveSize
    )
{
    ResShapeAnim* pResAnim = static_cast<ResShapeAnim*>(GetResAnim());
    NW_G3D_ASSERTMSG(curveIndex != -1, "%s\n", NW_G3D_RES_GET_NAME(pResAnim, GetName()));

    if (animIndex >= m_EditVertexShapeAnimCount)
    {
        NW_G3D_EDIT_WARNING_INDEX_BOUNDS(animIndex, m_EditVertexShapeAnimCount);
        return;
    }

    EditShapeAnimObj::EditVertexShapeAnim* editVertexShapeAnim = &m_pEditVertexShapeAnimArray[animIndex];

    int curveCount = editVertexShapeAnim->GetEditAnimCurveCount();
    if (curveIndex >= curveCount)
    {
        NW_G3D_EDIT_WARNING_INDEX_BOUNDS(curveIndex, curveCount);
        return;
    }

    EditAnimCurve* editAnimCurve = editVertexShapeAnim->GetEditAnimCurve(curveIndex);
    editAnimCurve->Edit(resAnimCurve->ptr(), resAnimCurveSize);
}

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
