﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "ut/g3d_FixedSizeArray.h"
#include "ut/g3d_EditWorkBuffer.h"

namespace nw { namespace g3d {

namespace res {

struct ResShaderProgramData;
class ResShadingModel;

} // namespace res

namespace edit {

class EditServer;
class IAllocator;

namespace detail {

class EditShaderProgram;
class EditShaderArchive;

/**
    @briefprivate 編集対象シェーディングモデルクラスです。
 */
class EditShadingModel
{
    friend class EditShaderArchive;
    friend void UpdateProgram(nw::g3d::ResShadingModel*, int);

public:
    bool Init();
    void Cleanup();
    void Destroy();

    EditShaderProgram* GetEditShaderProgram(int programIndex)
    {
        return m_ShaderProgramArray.UnsafeAt(programIndex);
    }

    int GetEditShaderProgramCount() const
    {
        return m_ShaderProgramArray.Size();
    }

    const EditShaderArchive* GetEditShaderArchive() const
    {
        return m_pEditShaderArchive;
    }

    void UpdateShadingModel(ResShaderArchive* resShaderArchive);

private:
    explicit EditShadingModel(
        IAllocator* allocator,
        u32 shaderArchiveKey,
        int shadingModelIndex,
        ResShadingModel* resShadingModel,
        EditShaderArchive* editShaderArchive);

private:
    IAllocator*                                         m_pAllocator;
    ResShadingModel*                                    m_pTargetResShadingModel;
    ut::detail::FixedSizeArray<EditShaderProgram>     m_ShaderProgramArray;
    u32                                                 m_ShaderArchiveKey;
    int                                                 m_ShadingModelIndex;
    const EditShaderArchive*                            m_pEditShaderArchive;

    void* m_pOriginalGLShaderInfo;
    ResShadingModel* m_pUpdateResShadingModel;

    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditShadingModel);
};

}} // nw::g3d::edit::detail
}} // namespace nw::g3d

#endif // NW_G3D_CONFIG_USE_HOSTIO
