﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include "ut/g3d_DynamicPtrArray.h"
#include "ut/g3d_EditWorkBuffer.h"

#if NW_G3D_CONFIG_USE_HOSTIO

namespace nw { namespace g3d { namespace edit {

namespace detail {

class EditSocket;

class EditPickup
{
public:
    explicit EditPickup(IAllocator* allocator)
        : m_pAllocator(allocator)
        , m_WorkBuffer(allocator)
        , m_MaterialPickups(allocator, DEFAULT_ALIGNMENT)
        , m_PickupBufferSize(0)
    {
        NW_G3D_ASSERT_NOT_NULL(allocator);
    }

    bool PushMaterialPickup(const ModelObj* modelObj, s32 materialIndex);
    void Clear();
    void Destroy();

    bool MakePickupPacket();
    bool SendPickup(EditSocket* socket);

private:
    size_t CalcWorkBufferSize();
    void MakePickupPacketBuffer();
private:
    class MaterialPickup
    {
        friend class EditPickup;
    public:
        explicit MaterialPickup(const ModelObj* modelObj, s32 materialIndex)
            : m_pModelObj(modelObj)
            , m_MaterialIndex(materialIndex)
        {}
    private:
        const ModelObj* m_pModelObj;
        s32 m_MaterialIndex;
    };

private:
    IAllocator* m_pAllocator;
    ut::detail::EditWorkBuffer m_WorkBuffer;
    ut::detail::DynamicPtrArray<MaterialPickup> m_MaterialPickups;
    size_t m_PickupBufferSize;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditPickup);
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
