﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#if NW_G3D_IS_HOST_CAFE

#include <cafe/fs.h>

#endif

namespace nw { namespace g3d { namespace edit {

class EditServer;

namespace detail {

class HostFileDevice
{
public:
    enum OpenFlag
    {
        READ_ONLY,
    };

    struct InitArg
    {
#if NW_G3D_IS_HOST_CAFE
        FSClient* hostFileIOHandle;
#endif
        explicit InitArg()
#if NW_G3D_IS_HOST_CAFE
        : hostFileIOHandle(NULL)
#endif
       {}
    };

public:
    explicit HostFileDevice();
    ~HostFileDevice();

    bool Initialize(const InitArg& arg);

    bool Open(const char* fileName, OpenFlag flag);
    void Close();

    bool ReadASync(void* buf, u32 size);

    bool IsReading() const;

    bool IsValidHandle() const;

private:

#if NW_G3D_IS_HOST_CAFE

    static void ReadCallback(
        FSClient*       client,
        FSCmdBlock*     block,
        FSStatus        result,
        void*           context);

    static void StateChangeCallback(FSClient* client, FSVolumeState state, void* context);
#endif

#if NW_G3D_IS_HOST_WIN

    // windows.h をヘッダーにインクルードしないための対処です。
    struct Impl;
    Impl* m_Impl;
    u8 m_FileIOMemberBuffer[sizeof(u32) * 16]; // バッファは多めにとっています。

    char*           m_pWriteBuffer;
    char*           m_pReadBuffer;

#else

    FSCmdBlock      m_CmdBlock;
    FSFileHandle    m_Handle;
    FSClient*       m_ClientPtr;
    FSClient        m_Client;
    FSStatus        m_ReadStatus;
    char m_MountPath[FS_MAX_MOUNTPATH_SIZE];
    char m_FileFullPath[FS_MAX_FULLPATH_SIZE];
    bool            m_IsExternalClientHandle;

#endif

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(HostFileDevice);
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
