﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/g3d_EditDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

namespace nw {
namespace g3d {
namespace edit {

class IAllocator;

namespace detail {

class EditManager;

// ユーザの処理と排他的に扱わなければいけないコマンド処理を実行するクラスです。
// - コールバックをコールする処理
// - ユーザが触れるデータを書き換える処理
class EditCommandExecutor
{
public:
    EditCommandExecutor(IAllocator* pAllocator, EditCallback* pCallback, EditManager* pEditManager);

    void ExecuteUserScript(UserScriptBlock* pBlock);
    void ExecutePickup(CommandFlag command, EditValueInfoBlock* pBlock);
    void ExecuteBindAnimation(CommandFlag command, BindAnimInfoBlock* pBlock);
    void ExecuteEditAnimationCurve(CommandFlag command, AnimCurveBlock* pBlock);
    void ExecuteEditMaterial(EditValueInfoBlock* pBlock);
    void ExecuteEditRenderInfo(RenderInfoEditInfo* pInfo);
    void ExecuteUnloadFile(FileDataBlock* pBlock);

private:
    IAllocator* m_pAllocator;
    EditManager* m_pEditManager;
    EditCallback* m_pCallback;
};

}}}} // namespace evfl::edit::internal

#endif // EVFL_CONFIG_USE_HOSTIO
