﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_SdkLog.h>

#include <nn/ndd/detail/ndd_Utility.h>

namespace nn { namespace ndd {

void PrintByteDataAsHex(const void* pData, uint16_t length)
{
#ifdef NN_NDD_ENABLE_LOG
    NN_ABORT_UNLESS_NOT_NULL(pData);
    const uint8_t* data = reinterpret_cast<const uint8_t*>(pData);
    uint8_t byteCount=0;
    NN_UNUSED(data);

    for(uint16_t i=0;i<length;++i)
    {
        NN_SDK_LOG("%02X ",data[i]);
        ++byteCount;
        if(byteCount==16)
        {
            NN_SDK_LOG("\n");
            byteCount=0;
        }
    }
    if(byteCount!=0)
    {
        NN_SDK_LOG("\n");
    }
#else
    NN_UNUSED(pData);
    NN_UNUSED(length);
#endif
}

int64_t GetCurrentTimeMs()
{
    nn::os::Tick tick = nn::os::GetSystemTick();
    nn::TimeSpan timeSpan = nn::os::ConvertToTimeSpan(tick);
    NN_UNUSED(timeSpan);
    return timeSpan.GetMilliSeconds();
}

}}
