﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/migration/migration_UserMigrationServer.h>

#include <nn/migration/detail/migration_Result.h>
#include <nn/migration/user/migration_Interface.sfdl.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_IServiceObject.h>

namespace nn { namespace migration {

void swap(UserMigrationServer& o0, UserMigrationServer& o1) NN_NOEXCEPT
{
    std::swap(o0.m_Ptr, o1.m_Ptr);
}

UserMigrationServer::UserMigrationServer() NN_NOEXCEPT
    : m_Ptr(nullptr)
{
}
UserMigrationServer::UserMigrationServer(user::IServer* ptr) NN_NOEXCEPT
    : m_Ptr(ptr)
{
}
UserMigrationServer::UserMigrationServer(UserMigrationServer&& rhs) NN_NOEXCEPT
    : m_Ptr(rhs.m_Ptr)
{
    rhs.m_Ptr = nullptr;
}
UserMigrationServer::~UserMigrationServer() NN_NOEXCEPT
{
    if (m_Ptr)
    {
        sf::ReleaseSharedObject(m_Ptr);
    }
}
UserMigrationServer& UserMigrationServer::operator=(UserMigrationServer&& rhs) NN_NOEXCEPT
{
    UserMigrationServer tmp(std::move(rhs));
    swap(*this, tmp);
    return *this;
}

void UserMigrationServer::GetServerProfile(UserMigrationServerProfile* pOut) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);

    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->GetServerProfile(pOut));
}

account::Uid UserMigrationServer::GetUid() const NN_NOEXCEPT
{
    account::Uid uid;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->GetUid(&uid));
    return uid;
}

AsyncContext UserMigrationServer::PrepareAsync() NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> p;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->PrepareAsync(&p));
    return AsyncContext(p.Detach());
}

bool UserMigrationServer::IsConnectionRequired() const NN_NOEXCEPT
{
    bool requirement;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->GetConnectionRequirement(&requirement));
    return requirement;
}

AsyncContext UserMigrationServer::WaitConnectionAsync() NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> p;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->WaitConnectionAsync(&p));
    return AsyncContext(p.Detach());
}

void UserMigrationServer::GetClientProfile(UserMigrationClientProfile* pOut) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOut);

    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->GetClientProfile(pOut));
}

AsyncContext UserMigrationServer::AcceptConnectionAsync() NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> p;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->AcceptConnectionAsync(&p));
    return AsyncContext(p.Detach());
}

AsyncContext UserMigrationServer::DeclineConnectionAsync() NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> p;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->DeclineConnectionAsync(&p));
    return AsyncContext(p.Detach());
}

AsyncContext UserMigrationServer::ProcessTransferAsync() NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> p;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->ProcessTransferAsync(&p));
    return AsyncContext(p.Detach());
}

AsyncContext UserMigrationServer::CompleteAsync() NN_NOEXCEPT
{
    sf::SharedPointer<detail::IAsyncContext> p;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_Ptr->CompleteAsync(&p));
    return AsyncContext(p.Detach());
}

Result UserMigrationServer::Abort() NN_NOEXCEPT
{
    return m_Ptr->Abort();
}

}} // ~namespace nn::migration
