﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/migration/idc/detail/migration_HandleErrorInfo.h>
#include <nn/migration/idc/migration_Result.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace migration { namespace idc { namespace detail {

Result HandleErrorInfo(const ErrorInfo& errorInfo) NN_NOEXCEPT
{
    switch( errorInfo.errorId )
    {
    case ErrorKind::ServiceStopped:
        NN_RESULT_THROW(ResultServiceStopped());
    default:
        NN_RESULT_THROW(ResultUnknownErrorResponse());
    }
}

}}}}
