﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>

#include "manu_Usb.h"

namespace nn { namespace manu { namespace detail {

void InitializeForUsbTransfer(int portNumber) NN_NOEXCEPT;
nn::Result UsbRead(size_t* pOutSuccessReadSize, void* pOutBuffer, size_t bufferSize, size_t readSize) NN_NOEXCEPT;
nn::Result UsbWrite(size_t* pOutSuccessWriteSize, const void* pBuffer, size_t bufferSize, size_t writeSize) NN_NOEXCEPT;

}}}
