﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>

namespace nn { namespace manu { namespace detail {

    const uint64_t MagicNumber = 0xDEADCAFEDEADCAFE;

    enum class ResultId : uint32_t
    {
        Success       = 0,
        ArgumentNullException,
        SecurityException,
        ArgumentException,
        UnauthorizedAccessException,
        PathTooLongException,
        NotSupportedException,
        FileNotFoundException,
        Undefined     = 0xFFFFFFFF,
    };

    enum class RequestId : uint32_t
    {
        Nop = 0,
        GetFileSize = 1,
        ReadFromHost = 2,
        WriteToHost = 3,
    };

    struct ReadWriteBody
    {
        size_t Length;
        size_t Offset;
        char   Path[256];
    };

    struct ResultValue
    {
        uint64_t    MagicNumber;
        ResultId    Id;
        uint32_t  Reserved;
        uint64_t  ReturnValue;
    };

    struct RequestHeader
    {
        uint64_t    MagicNumber;
        RequestId Request;
        uint32_t    Reserved;
        uint64_t    BodySize;
    };


}}}
