﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_ThreadCommon.h>
#include <nn/ldn/detail/ldn_Core.h>
#include <nn/ldn/detail/ldn_LocalCommunicationServiceManager.h>
#include <nn/ldn/detail/Debug/ldn_Log.h>
#include <nn/ldn/detail/Service/ldn_MonitorService.h>
#include <nn/ldn/detail/Service/ldn_ServiceCreator.h>
#include <nn/ldn/detail/Service/ldn_SystemLocalCommunicationService.h>
#include <nn/ldn/detail/Service/ldn_UserLocalCommunicationService.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace ldn { namespace detail { namespace
{
    // サービスオブジェクトの生成に使用するアロケータです。
    struct CreateServiceTag;
    typedef nn::sf::ExpHeapStaticAllocator<16 * 1024, CreateServiceTag> ServiceAllocator;

    // ServiceAllocator を静的コンストラクタで初期化するヘルパです。
    class ServiceAllocatorInitializer
    {
    public:
        ServiceAllocatorInitializer() NN_NOEXCEPT
        {
            ServiceAllocator::Initialize(nn::lmem::CreationOption_NoOption);
        }
    } g_ServiceAllocatorInitializer;

    // ローカル通信のコア機能を提供するオブジェクトです。
    const size_t CoreBufferSize = Core::RequiredBufferSize;
    NN_OS_ALIGNAS_THREAD_STACK char g_CoreBuffer[CoreBufferSize];
    Core g_Core(g_CoreBuffer, sizeof(g_CoreBuffer));

    // ローカル通信のサービスを管理するオブジェクトです。
    const size_t ManagerBufferSize = LocalCommunicationServiceManager::RequiredBufferSize;
    NN_OS_ALIGNAS_THREAD_STACK char g_ManagerBuffer[ManagerBufferSize];
    LocalCommunicationServiceManager g_Manager(g_ManagerBuffer, sizeof(g_ManagerBuffer), &g_Core);

}}}} // namespace nn::ldn::detail::<unnamed>

namespace nn { namespace ldn { namespace detail
{
    UserServiceCreator::UserServiceCreator() NN_NOEXCEPT
    {
    }

    UserServiceCreator::~UserServiceCreator() NN_NOEXCEPT
    {
    }

    Result UserServiceCreator::CreateUserLocalCommunicationService(
        nn::sf::Out<nn::sf::SharedPointer<IUserLocalCommunicationService>>
        pOutService) NN_NOEXCEPT
    {
        NN_LDN_LOG_DEBUG("created a user local communication service\n");
        *pOutService = nn::sf::ObjectFactory<ServiceAllocator::Policy>::CreateSharedEmplaced<
            IUserLocalCommunicationService, UserLocalCommunicationService>(&g_Manager);
        NN_RESULT_SUCCESS;
    }

    MonitorServiceCreator::MonitorServiceCreator() NN_NOEXCEPT
    {
    }

    MonitorServiceCreator::~MonitorServiceCreator() NN_NOEXCEPT
    {
    }

    Result MonitorServiceCreator::CreateMonitorService(
        nn::sf::Out<nn::sf::SharedPointer<IMonitorService>> pOutService) NN_NOEXCEPT
    {
        NN_LDN_LOG_DEBUG("created a monitor service\n");
        *pOutService = nn::sf::ObjectFactory<ServiceAllocator::Policy>::CreateSharedEmplaced<
            IMonitorService, MonitorService>(&g_Core);
        NN_RESULT_SUCCESS;
    }

    SystemServiceCreator::SystemServiceCreator() NN_NOEXCEPT
    {
    }

    SystemServiceCreator::~SystemServiceCreator() NN_NOEXCEPT
    {
    }

    Result SystemServiceCreator::CreateSystemLocalCommunicationService(
        nn::sf::Out<nn::sf::SharedPointer<ISystemLocalCommunicationService>>
        pOutService) NN_NOEXCEPT
    {
        NN_LDN_LOG_DEBUG("created a system local communication service\n");
        *pOutService = nn::sf::ObjectFactory<ServiceAllocator::Policy>::CreateSharedEmplaced<
            ISystemLocalCommunicationService, SystemLocalCommunicationService>(&g_Manager);
        NN_RESULT_SUCCESS;
    }

}}} // namespace nn::ldn::detail
