﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>
#include <nn/irsensor/identification/identification_Api.h>
#include <nn/irsensor/irsensor_TeraPluginProcessorApiPrivate.h>
#include <nn/xcd/xcd_IrsensorTypes.h>

#include "detail/irsensor_ApiImpl.h"

namespace nn { namespace irsensor {


::nn::Result RunIdentificationProcessor(const IrCameraHandle& handle) NN_NOEXCEPT
{
    const int IdentificationMode = 11;

    TeraPluginProcessorConfig teraConfig = {};
    teraConfig.modeOffset = static_cast<uint8_t>(IdentificationMode - static_cast<int>(nn::xcd::IrProcessorType::TeraPlugin));
    teraConfig.isParameterEnabled = false;

    return RunTeraPluginProcessor(handle, teraConfig);
}

} } // namespace nn::irsensor
