﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/irsensor/irsensor_IIrSensorSystemServer.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>

namespace nn { namespace irsensor { namespace detail {

//!< irsensor システム機能サービスを扱うクラスです。
class IrSensorSystemServer final
{
    NN_DISALLOW_COPY(IrSensorSystemServer);
    NN_DISALLOW_MOVE(IrSensorSystemServer);

public:
    IrSensorSystemServer() NN_NOEXCEPT;

    //!< アプレットリソースユーザ ID を設定します。
    ::nn::Result SetAppletResourceUserId(
        const ::nn::applet::AppletResourceUserId& value) NN_NOEXCEPT;

    //!< アプレットリソースユーザ ID を登録します。
    ::nn::Result RegisterAppletResourceUserId(
        const ::nn::applet::AppletResourceUserId& aruid,
        bool enablesInput) NN_NOEXCEPT;

    //!< アプレットリソースユーザ ID の登録を解除します。
    ::nn::Result UnregisterAppletResourceUserId(
        const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;

    //!< IR センサー入力の提供を行うか否かを設定します。
    ::nn::Result EnableAppletToGetInput(
        const ::nn::applet::AppletResourceUserId& aruid,
        bool enablesInput) NN_NOEXCEPT;
};

//!< irsensor システム機能サービスのプロクシを作成します。
::nn::Result CreateIrSensorSystemServerProxy(
    ::nn::sf::SharedPointer<IIrSensorSystemServer>* pOutValue) NN_NOEXCEPT;

}}} // namespace nn::irsensor::detail
