﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hidbus/hidbus_IHidbusSystemServer.sfdl.h>
#include <nn/hidbus/detail/hidbus_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/hidbus/server/hidbus_HidbusSystemServer.h>

#include "hidbus_SchedulerTask.h"
#include "hidbus_StaticObject.h"
#include "hidbus_ResourceHolder.h"
#include "../detail/hidbus_InternalDefinition.h"
#include <nn/nn_SdkLog.h>

namespace nn { namespace hidbus { namespace server {

HidbusSystemServer::HidbusSystemServer() NN_NOEXCEPT
{
    // 何もしない
}

HidbusSystemServer::~HidbusSystemServer() NN_NOEXCEPT
{
    // 何もしない
}

nn::Result HidbusSystemServer::SetAppletResourceUserId(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
    GetResourceHolder().SetInFocusAruid(aruid);
    for (int i = 0; i < nn::hidbus::detail::MaxHidbusNumber; i++)
    {
        auto internalAruid = GetResourceHolder().GetAppletResourceUserId(i);
        if (internalAruid != nn::applet::AppletResourceUserId::GetInvalidId())
        {
            if (internalAruid != aruid)
            {
                GetSchedulerTask().AddFocusChangeTask(i);
                GetResourceHolder().GetStatusManager()->SetFocusStatus(false, i);
                NN_DETAIL_HIDBUS_INFO("Set Not InFocus\n");
            }
            else
            {
                GetResourceHolder().GetStatusManager()->SetFocusStatus(true, i);
            }
        }
    }
    // NN_DETAIL_HIDBUS_INFO_V1("Got ARUID (%d)\n", aruid);

    NN_RESULT_SUCCESS;
}

nn::Result HidbusSystemServer::RegisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, int32_t appletId) NN_NOEXCEPT
{
    NN_UNUSED(aruid);
    NN_UNUSED(appletId);

    // TORAIAEZU
    // アプリ以外にアプレットが hidbus を使うようになった場合、もろもろを勝手に終了しないために、
    // Register 済みの ARUID を管理する必要があるが、今はアプリだけなので、何もしない。

    NN_RESULT_SUCCESS;
}

nn::Result HidbusSystemServer::UnregisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
    NN_UNUSED(aruid);

    GetSchedulerTask().UnregisterApplication(aruid);

    //NN_DETAIL_HIDBUS_INFO_V1("Unregister ARUID (%d)\n", aruid);
    NN_RESULT_SUCCESS;
}

::nn::Result CreateHidbusSystemServerProxy(
    ::nn::sf::SharedPointer<IHidbusSystemServer>* outValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outValue);
    *outValue = nn::hidbus::detail::StaticObject<
        ::nn::sf::UnmanagedServiceObject<IHidbusSystemServer, HidbusSystemServer>
        >::Get().GetShared();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hidbus::server
