﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/hidbus/hidbus.h>

#include "hidbus_InternalDefinition.h"

namespace nn { namespace hidbus { namespace detail {

class StatusManager final
{
    NN_DISALLOW_COPY(StatusManager);
    NN_DISALLOW_MOVE(StatusManager);

private:

    // NOTE : このステータスはアプリ用。後々アプレット対応するときは別で用意する。
    struct StatusFormat
    {
        ::std::atomic<bool>  isConnected;
        nn::Result           isConnectedResult;
        ::std::atomic<bool>  isEnabled;
        ::std::atomic<bool>  isInFocus;
        ::std::atomic<bool>  isPollingMode;
        ::std::atomic<int>   pollingMode;

        char _padding[240];
    };

    NN_STATIC_ASSERT(sizeof(StatusFormat) == 256U);

    //!< SharedMemory に配置されるフォーマット
    StatusFormat m_StatusFormat[16];

public:
    StatusManager() NN_NOEXCEPT
    {
        for (int i = 0; i < detail::MaxHidbusNumber; i++)
        {
            m_StatusFormat[i].isConnected = false;
            m_StatusFormat[i].isConnectedResult = nn::ResultSuccess();
            m_StatusFormat[i].isEnabled = false;
            m_StatusFormat[i].isInFocus = true;
            m_StatusFormat[i].isPollingMode = false;
        }
    }

    ~StatusManager() NN_NOEXCEPT
    {
    }

    nn::Result IsConnected(bool* pOutIsConnected, int index) NN_NOEXCEPT
    {
        *pOutIsConnected = m_StatusFormat[index].isConnected;
        return m_StatusFormat[index].isConnectedResult;
    }

    void SetAttachmentState(bool isConnected, nn::Result result, int index) NN_NOEXCEPT
    {
        m_StatusFormat[index].isConnected = isConnected;
        m_StatusFormat[index].isConnectedResult = result;
    }

    bool IsEnabled(int index) NN_NOEXCEPT
    {
        return m_StatusFormat[index].isEnabled;
    }

    void SetEnableState(bool isEnabled, int index) NN_NOEXCEPT
    {
        m_StatusFormat[index].isEnabled = isEnabled;
    }

    bool IsInFocus(int index) NN_NOEXCEPT
    {
        return m_StatusFormat[index].isInFocus;
    }

    void SetFocusStatus(bool isInForcus, int index) NN_NOEXCEPT
    {
        m_StatusFormat[index].isInFocus = isInForcus;
    }

    bool IsPollingMode(int index) NN_NOEXCEPT
    {
        return m_StatusFormat[index].isPollingMode;
    }

    void SetPollingModeState(bool isPollingMode, int index) NN_NOEXCEPT
    {
        m_StatusFormat[index].isPollingMode = isPollingMode;
    }

    int GetPollingMode(int index) NN_NOEXCEPT
    {
        return m_StatusFormat[index].pollingMode;
    }

    void SetPollingMode(int pollingMode, int index) NN_NOEXCEPT
    {
        m_StatusFormat[index].pollingMode = pollingMode;
    }
};

}}} // namespace nn::hidbus::detail
