﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hidbus/hidbus_IHidbusSystemServer.sfdl.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>

#include "hidbus_AppletImpl.h"
#include "hidbus_HidbusSystemServerByHipc.h"

namespace nn { namespace hidbus { namespace detail {

::nn::Result SetAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidbusSystemServer> pProxy;
    NN_RESULT_DO(CreateHidbusSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetAppletResourceUserId(value));
    NN_RESULT_SUCCESS;
}

::nn::Result RegisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid,
    ::nn::applet::AppletId appletId) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidbusSystemServer> pProxy;
    NN_RESULT_DO(CreateHidbusSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->RegisterAppletResourceUserId(aruid, static_cast<int32_t>(appletId)));
    NN_RESULT_SUCCESS;
}

::nn::Result UnregisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidbusSystemServer> pProxy;
    NN_RESULT_DO(CreateHidbusSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->UnregisterAppletResourceUserId(aruid));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hidbus::detail
