﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/hid/debug/hid_Xpad.h>
#include <nn/os/os_SystemEvent.h>

#include "detail/hid_BasicXpadImpl.h"
#include "detail/hid_XpadImpl.h"

namespace nn { namespace hid {

void BindXpadIdEvent(::nn::os::SystemEventType* pEvent,
                     ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::BindXpadIdEvent(pEvent, clearMode));
}

void UnbindXpadIdEvent(::nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::UnbindXpadIdEvent(pEvent));
}

int GetXpadIds(BasicXpadId* outXpadIds, int count) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetXpadIds(&gotCount, outXpadIds, count));
    return gotCount;
}

int GetXpadPlayerNumber(const BasicXpadId& xpadId) NN_NOEXCEPT
{
    int value;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetXpadPlayerNumber(&value, xpadId));
    return value;
}

void InitializeXpad(const BasicXpadId& xpadId) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeXpad(xpadId));
}

void GetXpadState(BasicXpadState* outValue, const BasicXpadId& xpadId
                  ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetXpadState(outValue, xpadId));
}

int GetXpadStates(BasicXpadState* outStates,
                  int count,
                  const BasicXpadId& xpadId) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetXpadStates(&gotCount, outStates, count, xpadId));
    return gotCount;
}

}} // namespace nn::hid


namespace nn { namespace hid { namespace debug {

void FinalizeXpad(const BasicXpadId& xpadId) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::FinalizeXpad(xpadId));
}

void SetXpadAutoPilotState(const BasicXpadId& xpadId,
                           const BasicXpadAutoPilotState& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::SetXpadAutoPilotState(xpadId, value));
}

void UnsetXpadAutoPilotState(const BasicXpadId& xpadId) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::UnsetXpadAutoPilotState(xpadId));
}

}}} // namespace nn::hid::debug
