﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadJoyCommon.h>
#include <nn/hid/hid_Result.h>
#include <nn/hid/hid_ResultController.h>
#include <nn/os/os_SystemEvent.h>

#include "detail/hid_NpadImpl.h"
#include "detail/hid_NpadCommonImpl.h"

namespace nn { namespace hid {

NpadJoyAssignmentMode GetNpadJoyAssignment(const NpadIdType& id) NN_NOEXCEPT
{
    NpadJoyAssignmentMode assignment;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetNpadJoyAssignment(&assignment, id));

    return assignment;
}

void SetNpadJoyAssignmentModeSingle(const NpadIdType& id) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetNpadJoyAssignmentModeSingle(id));
}

void SetNpadJoyAssignmentModeSingle(const NpadIdType& id, NpadJoyDeviceType type) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetNpadJoyAssignmentModeSingle(id, type));
}

bool SetNpadJoyAssignmentModeSingle(NpadIdType* pOutValue, const NpadIdType& id, NpadJoyDeviceType type) NN_NOEXCEPT
{
    bool isAssigned;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetNpadJoyAssignmentModeSingle(&isAssigned, pOutValue, id, type));
    return isAssigned;
}

void SetNpadJoyAssignmentModeDual(const NpadIdType& id) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetNpadJoyAssignmentModeDual(id));
}

Result MergeSingleJoyAsDualJoy(const NpadIdType& id1, const NpadIdType& id2) NN_NOEXCEPT
{
    auto result = detail::MergeSingleJoyAsDualJoy(id1, id2);

    if(result.IsFailure() == true &&
       ResultNpadDualConnected::Includes(result) == false &&
       ResultNpadSameJoyTypeConnected::Includes(result) == false)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

void SwapNpadAssignment(const NpadIdType& id1, const NpadIdType& id2) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SwapNpadAssignment(id1, id2));
}

void SetNpadJoyHoldType(NpadJoyHoldType holdType) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetNpadJoyHoldType(holdType));
}

NpadJoyHoldType GetNpadJoyHoldType() NN_NOEXCEPT
{
    NpadJoyHoldType holdType;

    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetNpadJoyHoldType(&holdType));

    return holdType;
}

void StartLrAssignmentMode() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::StartLrAssignmentMode());
}

void StopLrAssignmentMode() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::StopLrAssignmentMode());
}

void SetNpadHandheldActivationMode(NpadHandheldActivationMode mode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetNpadHandheldActivationMode(mode));
}

NpadHandheldActivationMode GetNpadHandheldActivationMode() NN_NOEXCEPT
{
    NpadHandheldActivationMode mode;

    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetNpadHandheldActivationMode(&mode));

    return mode;
}

void SetNpadCommunicationMode(NpadCommunicationMode mode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetNpadCommunicationMode(mode));
}

NpadCommunicationMode GetNpadCommunicationMode() NN_NOEXCEPT
{
    NpadCommunicationMode mode;

    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetNpadCommunicationMode(&mode));

    return mode;
}

}} // namespace nn::hid
