﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadGc.h>
#include <nn/os/os_SystemEvent.h>

#include "detail/hid_NpadImpl.h"

namespace nn { namespace hid {

void GetNpadState(NpadGcState* pOutValue, const NpadIdType& id
                  ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetNpadState(pOutValue, id));
}

int GetNpadStates(NpadGcState* pOutValues,
                  int count,
                  const NpadIdType& id) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetNpadStates(&gotCount, pOutValues, count, id));
    return gotCount;
}

}} // namespace nn::hid
