﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Xpad.h>

#include "hid_CommonStateUtility.h"

namespace nn { namespace hid { namespace detail {

//!< 基本的な構成を持つ Xpad のデジタルボタンの入力状態をマージします。
inline BasicXpadButtonSet MergeXpadButtons(const BasicXpadButtonSet& lhs,
                                           const BasicXpadButtonSet& rhs
                                           ) NN_NOEXCEPT
{
    return MergeButtonsIncludingDpad(lhs, rhs);
}

//!< 基本的な構成を持つ Xpad のデジタルボタンに禁則処理を適応します。
inline BasicXpadButtonSet RestrictXpadButtons(const BasicXpadButtonSet& buttons
                                              ) NN_NOEXCEPT
{
    return RestrictButtonsIncludingDpad(buttons, ControlPadRestrictionType_KeepUpAndLeft, true);
}

//!< 基本的な構成を持つ Xpad の入力状態をマージします。
inline BasicXpadState MergeXpadState(const BasicXpadState& lhs,
                                     const BasicXpadState& rhs,
                                     bool usesFirstAnalogStickState) NN_NOEXCEPT
{
    BasicXpadState state = {};

    state.attributes.Set<BasicXpadAttribute::IsConnected>(
        lhs.attributes.Test<BasicXpadAttribute::IsConnected>() ||
        rhs.attributes.Test<BasicXpadAttribute::IsConnected>());

    state.buttons = MergeXpadButtons(lhs.buttons, rhs.buttons);

    if (usesFirstAnalogStickState)
    {
        state.analogStickL = lhs.analogStickL;
        state.analogStickR = lhs.analogStickR;
    }
    else
    {
        state.analogStickL = rhs.analogStickL;
        state.analogStickR = rhs.analogStickR;
    }

    return state;
}

}}} // namespace nn::hid::detail
