﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/TargetConfigs/build_Base.h>

#include "hid_RingLifo.h"

namespace nn { namespace hid { namespace detail {

class BasicXpadLifo final : public RingLifo<BasicXpadState, XpadStateCountMax>
{
public:
    BasicXpadLifo() NN_NOEXCEPT { /* 何もしない */ }
};

#ifdef NN_BUILD_CONFIG_TOOLCHAIN_CLANG
NN_STATIC_ASSERT(::std::is_standard_layout<BasicXpadLifo>::value);
#endif

}}} // namespace nn::hid::detail
