﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace hid { namespace detail {

//!< Xpad ID の値を作成します。
int MakeXpadIdValue(int playerNumber) NN_NOEXCEPT;

//!< Xpad ID の値からプレイヤー番号を取得します。
int GetXpadIdValuePlayerNumber(int storage) NN_NOEXCEPT;

//!< Xpad ID を作成します。
template<typename T>
inline T MakeXpadId(int playerNumber) NN_NOEXCEPT
{
    T xpadId = { MakeXpadIdValue(playerNumber) };
    return xpadId;
}

//!< Xpad ID からプレイヤー番号を取得します。
template<typename T>
inline int GetXpadIdPlayerNumber(const T& xpadId) NN_NOEXCEPT
{
    return GetXpadIdValuePlayerNumber(xpadId._storage);
}

}}} // namespace nn::hid::detail
