﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Windows.h>
#include <hidsdi.h>

#include "hid_WindowsGenericPadAccessor-os.win.h"

namespace nn { namespace hid { namespace detail {

//!< HID デバイスのハンドルを表す構造体です。
struct HidSdiHandle final
{
    HANDLE handle;
    PHIDP_PREPARSED_DATA pPreparsedData;
    BOOL isPending;
    OVERLAPPED overlapped;
    ULONG inputReportCount;
    char inputReport[64];
};

//!< HID ゲームパッドの状態を表す構造体です。
struct HidSdiGamePadState final
{
    uint64_t buttons;
    int pov;
    int positions[6];
};

//!< ゲームパッドか否かを表す値を返します。
bool IsHidSdiGamePad(USHORT usagePage, USHORT usage) NN_NOEXCEPT;

//!< HID デバイスのハンドルを作成します。
HidSdiHandle CreateHidSdiHandle() NN_NOEXCEPT;

//!< HID デバイスのハンドルが有効か否かを表す値を返します。
bool IsHidSdiHandleValid(const HidSdiHandle& handle) NN_NOEXCEPT;

//!< HID デバイスをオープンします。
::nn::Result OpenHidSdiDevice(
    HidSdiHandle* pOutHandle, const char deviceName[]) NN_NOEXCEPT;

//!< HID デバイスを閉じます。
void CloseHidSdiDevice(HidSdiHandle* pHandle) NN_NOEXCEPT;

//!< HID ゲームパッドの状態を更新します。
::nn::Result GetHidSdiGamePadState(
    HidSdiHandle* pHandle, HidSdiGamePadState* pOutValue) NN_NOEXCEPT;

//!< HID ゲームパッドの能力を取得します。
::nn::Result GetHidSdiGamePadCapability(
    WindowsGenericPadAbility* pOutValue, const char deviceName[]) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
