﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_IHidSystemServer.sfdl.h>

#include "hid_AppletResourceUserId.h"
#include "hid_HidSystemServer.h"
#include "hid_VibrationMasterVolumeImpl.h"

namespace nn { namespace hid { namespace detail {

Result SetVibrationMasterVolume(float masterVolume) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->SetVibrationMasterVolume(masterVolume));
    NN_RESULT_SUCCESS;
}

Result GetVibrationMasterVolume(float* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->GetVibrationMasterVolume(pOutValue));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
