﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/hid/system/hid_UsbFullKey.h>

namespace nn { namespace hid { namespace detail {

::nn::Result IsUsbFullKeyControllerEnabled(bool* pOutValue) NN_NOEXCEPT;

::nn::Result EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT;

::nn::Result IsUsbConnected(bool* pOutValue, system::UniquePadId id) NN_NOEXCEPT;

::nn::Result IsUsbFullKeyControllerEnabledForApplication(bool* pOutValue) NN_NOEXCEPT;

::nn::Result EnableUsbFullKeyControllerForApplication(bool enabled) NN_NOEXCEPT;

::nn::Result IsUsbFullKeyControllerConnectedForApplication(bool* pOutValue, const NpadIdType& id) NN_NOEXCEPT;


}}} // namespace nn::hid::detail
