﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/hid/system/hid_SixAxisSensorCalibration.h>

#include "hid_SixAxisSensorCalibrator.h"
#include "hid_UniquePadAbstractedPadHolder.h"

namespace nn { namespace hid { namespace detail {

class UniquePadSixAxisSensorDriver final
{
    NN_DISALLOW_COPY(UniquePadSixAxisSensorDriver);
    NN_DISALLOW_MOVE(UniquePadSixAxisSensorDriver);

private:
    UniquePadAbstractedPadHolder* m_pAbstractedPadHolder;

    //!< 6軸センサーのキャリブレーションを担うクラス
    SixAxisSensorCalibrator m_Calibrator;

    //!< SixAxisSensor の Calibration 処理の状況
    system::SixAxisSensorUserCalibrationStage m_Stage;

public:
    UniquePadSixAxisSensorDriver() NN_NOEXCEPT;
    ~UniquePadSixAxisSensorDriver() NN_NOEXCEPT;

    //!< AbstractedPad を管理するクラスを設定します。
    void SetUniquePadAbstractedPadHolder(UniquePadAbstractedPadHolder* pHolder) NN_NOEXCEPT;

    //!< 6軸センサーのユーザーキャリブレーション処理を開始します。
    ::nn::Result StartSixAxisSensorUserCalibration() NN_NOEXCEPT;

    //!< 6軸センサーのユーザーキャリブレーション処理をキャンセルします。
    ::nn::Result CancelSixAxisSensorUserCalibration() NN_NOEXCEPT;

    //!< 6軸センサーのユーザーキャリブレーションの状況を取得します。
    ::nn::Result GetSixAxisSensorUserCalibrationStage(system::SixAxisSensorUserCalibrationStage* pOutValue) NN_NOEXCEPT;

    //!< 6軸センサーのユーザーキャリブレーションがサポートされているかどうかを取得します。
    bool IsSixAxisSensorUserCalibrationSupported() const NN_NOEXCEPT;

    //!< 6軸センサーのユーザーキャリブレーションを工程の状態に戻します。
    ::nn::Result ResetSixAxisSensorCalibrationValues() NN_NOEXCEPT;

    //!< AnalogStick の内部状態の更新を行います。
    void Update() NN_NOEXCEPT;

    //!< AnalogStick の内部状態を初期化します。
    void Reset() NN_NOEXCEPT;

private:
    ::nn::Result IsSixAxisSensorUserCalibrationSupportedImpl() const NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
