﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "hid_AbstractedPadXcd.h"
#include "hid_UniquePadAbstractedPadHolder.h"

namespace nn { namespace hid { namespace detail {

UniquePadAbstractedPadHolder::UniquePadAbstractedPadHolder() NN_NOEXCEPT
    : m_pPad(nullptr)
{
    // 何もしない
}

UniquePadAbstractedPadHolder::~UniquePadAbstractedPadHolder() NN_NOEXCEPT { /* 何もしない */ }

void UniquePadAbstractedPadHolder::AttachAbstractedPad(IAbstractedPad* pPad) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pPad);
    m_pPad = pPad;
}

bool UniquePadAbstractedPadHolder::CheckForDeviceDetach() NN_NOEXCEPT
{
    if (m_pPad == nullptr)
    {
        return false;
    }

    if (m_pPad->IsConnected() == false)
    {
        m_pPad = nullptr;
        return true;
    }

    return false;
}

bool UniquePadAbstractedPadHolder::GetIAbstractedPad(IAbstractedPad** ppOutValue) const NN_NOEXCEPT
{
    if (m_pPad == nullptr)
    {
        return false;
    }

    *ppOutValue = m_pPad;
    return true;
}

bool UniquePadAbstractedPadHolder::IsConnected() const NN_NOEXCEPT
{
    return (m_pPad != nullptr);
}

bool UniquePadAbstractedPadHolder::IsConnectedAbstractedPad(const AbstractedPadId& id) const NN_NOEXCEPT
{
    if (m_pPad != nullptr)
    {
        return m_pPad->GetId() == id;
    }
    return false;
}

bool UniquePadAbstractedPadHolder::GetXcdDeviceHandle(nn::xcd::DeviceHandle* pOutValue) const NN_NOEXCEPT
{
    if (m_pPad == nullptr)
    {
        return false;
    }

    if (m_pPad->GetType() != AbstractedPadType_Xcd)
    {
        return false;
    }

    *pOutValue = static_cast<AbstractedPadXcd*>(m_pPad)->GetXcdDeviceHandle();
    return true;
}

}}} // namespace nn::hid::detail
