﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>

#include "hid_SystemButtonNotifier.h"

namespace nn { namespace hid { namespace detail {

SystemButtonNotifier::SystemButtonNotifier() NN_NOEXCEPT
: m_pIsSystemButtonDown(nullptr)
    , m_pNeedsToSignal(nullptr)
    , m_IsNotifierSystemButtonActive(false)
    , m_IsNotifierSystemButtonDown(false)
{
    // 何もしない
}

SystemButtonNotifier::SystemButtonNotifier(const SystemButtonNotifier& other
                                           ) NN_NOEXCEPT
    : m_pIsSystemButtonDown(other.m_pIsSystemButtonDown)
    , m_pNeedsToSignal(other.m_pNeedsToSignal)
    , m_IsNotifierSystemButtonActive(other.m_IsNotifierSystemButtonActive)
    , m_IsNotifierSystemButtonDown(other.m_IsNotifierSystemButtonDown)
{
    // 何もしない
}

SystemButtonNotifier::SystemButtonNotifier(SystemButtonNotifier&& other
                                           ) NN_NOEXCEPT
    : m_pIsSystemButtonDown(other.m_pIsSystemButtonDown)
    , m_pNeedsToSignal(other.m_pNeedsToSignal)
    , m_IsNotifierSystemButtonActive(other.m_IsNotifierSystemButtonActive)
    , m_IsNotifierSystemButtonDown(other.m_IsNotifierSystemButtonDown)
{
    // 何もしない
}

SystemButtonNotifier& SystemButtonNotifier::operator=(
    const SystemButtonNotifier& other) NN_NOEXCEPT
{
    m_pIsSystemButtonDown = other.m_pIsSystemButtonDown;
    m_pNeedsToSignal = other.m_pNeedsToSignal;
    m_IsNotifierSystemButtonActive = other.m_IsNotifierSystemButtonActive;
    m_IsNotifierSystemButtonDown = other.m_IsNotifierSystemButtonDown;
    return *this;
}

SystemButtonNotifier& SystemButtonNotifier::operator=(
    SystemButtonNotifier&& other) NN_NOEXCEPT
{
    m_pIsSystemButtonDown = other.m_pIsSystemButtonDown;
    m_pNeedsToSignal = other.m_pNeedsToSignal;
    m_IsNotifierSystemButtonActive = other.m_IsNotifierSystemButtonActive;
    m_IsNotifierSystemButtonDown = other.m_IsNotifierSystemButtonDown;
    return *this;
}

void SystemButtonNotifier::SetSystemButtonState(bool isDown) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_pIsSystemButtonDown);
    NN_SDK_REQUIRES_NOT_NULL(m_pNeedsToSignal);

    if (isDown)
    {
        if (m_IsNotifierSystemButtonDown)
        {
            // 既に押下状態であれば何もしない
            return;
        }

        m_IsNotifierSystemButtonActive = !m_pIsSystemButtonDown->exchange(true);

        if (m_IsNotifierSystemButtonActive)
        {
            *m_pNeedsToSignal = true;
        }
    }
    else
    {
        if (!m_IsNotifierSystemButtonDown)
        {
            // 既に開放状態であれば何もしない
            return;
        }

        if (m_IsNotifierSystemButtonActive)
        {
            *m_pIsSystemButtonDown = false;
            *m_pNeedsToSignal = true;
            m_IsNotifierSystemButtonActive = false;
        }
    }

    m_IsNotifierSystemButtonDown = isDown;
}

}}} // namespace nn::hid::detail
