﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/applet/applet.h>
#include <nn/os/os_Tick.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/util/util_Quaternion.h>

#include <nerd/nerd_InertialMeasurementUnit.h>

#include "hid_ISixAxisSensorFilter.h"
#include "hid_ConsoleSixAxisSensorLifo.h"
#include "hid_SixAxisSensorFusionPolicy.h"

namespace nn { namespace hid { namespace detail {

class SixAxisSensorSanjiroFilter final : public ISixAxisSensorFilter
{
    NN_DISALLOW_COPY(SixAxisSensorSanjiroFilter);
    NN_DISALLOW_MOVE(SixAxisSensorSanjiroFilter);

public:

    SixAxisSensorSanjiroFilter() NN_NOEXCEPT;

    virtual ~SixAxisSensorSanjiroFilter() NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetAppletResourceUserId(const ::nn::applet::AppletResourceUserId& id) NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::applet::AppletResourceUserId GetAppletResourceUserId() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Reset() NN_NOEXCEPT NN_OVERRIDE;

    virtual void ResetState() NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetDirection(const nn::hid::DirectionState& direction) NN_NOEXCEPT NN_OVERRIDE;
    virtual void SetAngle(const nn::util::Float3& angle) NN_NOEXCEPT NN_OVERRIDE;
    virtual void SetPosition(const nn::util::Float3& position) NN_NOEXCEPT NN_OVERRIDE;

    virtual bool GetState(SevenSixAxisSensorState* pOutValue,
                          nn::os::Tick* lastTime = nullptr) NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetStates(SevenSixAxisSensorState* pOutStates,
                          int count,
                          nn::os::Tick* lastTime = nullptr ) NN_NOEXCEPT NN_OVERRIDE;

    virtual bool GetIsStill() NN_NOEXCEPT NN_OVERRIDE;

    virtual float GetVerticalizationError() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::util::Float3 GetGyroBias() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Update(const nn::util::Float3& acceleration,
                        const nn::util::Float3& angularVelocity,
                        const nn::os::Tick& time) NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetStateBuffer(const ::nn::applet::AppletResourceUserId& id, void* buffer, size_t size) NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetWorkBuffer(const ::nn::applet::AppletResourceUserId& id, void* buffer, size_t size) NN_NOEXCEPT NN_OVERRIDE;

    virtual void ClearStateBuffer() NN_NOEXCEPT NN_OVERRIDE;

    virtual void ClearWorkBuffer() NN_NOEXCEPT NN_OVERRIDE;

    virtual void StartCalibration() NN_NOEXCEPT NN_OVERRIDE;

    virtual void StopCalibration() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetAccurateUserCalibrationState(
        ::nn::hid::system::SixAxisSensorAccurateUserCalibrationState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetCalibrationParameters(
        ConsoleSixAxisSensorCalibrationParameters* pOutParameters) const NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetCalibrationParameters(
        const ConsoleSixAxisSensorCalibrationParameters& parameters) NN_NOEXCEPT NN_OVERRIDE;

    virtual bool IsWorkBufferAllocated() const NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetFilterSetting(const FilterSetting& setting) NN_NOEXCEPT NN_OVERRIDE;

private:
    void UpdateNerdImpl(nerd::float3 const& acceleration,
                        nerd::float3 const& angularVelocity,
                        float dt);

    void Update(const nn::util::Float3 &acceleration,
                const nn::util::Float3& angularVelocity,
                const nn::TimeSpan& timespan);

    void GetQuaternion(nn::util::Quaternion* pOutQuaternion) const;

    void ProceedCalibration();

private:

    int64_t m_SamplingNumber;
    int64_t m_CoordinationNumber;
    nn::os::Tick m_LastUpdateTime;

    nn::hid::DirectionState m_Direction;
    nn::util::Float3 m_Angle;
    nn::util::Float3 m_Position;

    float m_TickToSec;
    double m_CurrentTime{ 0 };

    nn::util::Quaternion m_Offset;
    bool m_HasVerticality;

    nerd::Imu m_Imu;
    ::nn::hid::detail::SevenSixAxisSensorStateLifo m_Lifo; // Filter が内部的に入力状態を保持するための LIFO

    ::nn::applet::AppletResourceUserId m_AppletResourceUserId;
    bool m_IsWorkBufferAllocated;

    ::nn::hid::system::SixAxisSensorAccurateUserCalibrationState m_SixAxisSensorAccurateUserCalibrationState;

    float m_ThresholdStillness;

    SixAxisSensorFusionPolicy m_SixAxisSensorFusionPolicy;
};

}}} // namespace nn::hid::detail

