﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadColor.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_NpadGc.h>
#include <nn/hid/hid_NpadPalma.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/system/hid_Npad.h>

namespace nn { namespace hid { namespace detail {

const system::DeviceTypeSet DeviceTypeMask_JoyCons =
    system::DeviceType::JoyConLeft::Mask |
    system::DeviceType::JoyConRight::Mask;

const system::DeviceTypeSet DeviceTypeMask_HandheldJoyCons =
    system::DeviceType::HandheldJoyLeft::Mask |
    system::DeviceType::HandheldJoyRight::Mask;

const system::DeviceTypeSet DeviceTypeMask_JoyLefts =
    system::DeviceType::JoyConLeft::Mask |
    system::DeviceType::HandheldJoyLeft::Mask;

const system::DeviceTypeSet DeviceTypeMask_JoyRights =
    system::DeviceType::JoyConRight::Mask |
    system::DeviceType::HandheldJoyRight::Mask;

const NpadStyleSet StyleSetMask_FullKeySupportedStyles =
    NpadStyleFullKey::Mask |
    NpadStyleGc::Mask;

const NpadStyleSet StyleSetMask_JoyLeftSupportedStyles =
    NpadStyleFullKey::Mask |
    NpadStyleJoyDual::Mask |
    NpadStyleJoyLeft::Mask;

const NpadStyleSet StyleSetMask_JoyRightSupportedStyles =
    NpadStyleFullKey::Mask |
    NpadStyleJoyDual::Mask |
    NpadStyleJoyRight::Mask;

const NpadStyleSet StyleSetMask_HandheldLeftSupportedStyles =
    NpadStyleHandheld::Mask;

const NpadStyleSet StyleSetMask_HandheldRightSupportedStyles =
    NpadStyleHandheld::Mask;

const NpadStyleSet StyleSetMask_PalmaSupportedStyles =
    NpadStylePalma::Mask;

const NpadStyleSet StyleSetMask_SystemCommonStyles =
    NpadStyleFullKey::Mask |
    NpadStyleHandheld::Mask |
    NpadStyleJoyDual::Mask |
    NpadStyleJoyLeft::Mask |
    NpadStyleJoyRight::Mask |
    NpadStylePalma::Mask |
    system::NpadStyleSystem::Mask |
    system::NpadStyleSystemExt::Mask;


}}} // namespace nn::hid::detail
